# -*- coding: utf-8 -*-
"""
Created on Fri Feb  5 16:32:39 2021

@author: alice
"""
from ModuleJoueur import Joueur
from ModuleMonstre import Monstre
from ModuleJournal import Journal
from ModuleGraphique import Graphique

import tkinter as tk
from random import randint
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg


monstre=Monstre("nom",0,0,[])
joueur=Joueur(monstre)
journal=Journal(monstre)
progression=Graphique(joueur)


pieces_visitees=[] 
num=0

def graphique():
    """Cette fonction ouvre une nouvelle fenêtre affichant
    le graphique représentant les carcatéristiques du joueur
    au cours de sa progression.
    Elle est appelé dans la fonction choix() et utilise
    l'objet progression de la class Graphique."""
    
    progression.actualiser()
    
    fenetre_prog=tk.Tk()
    fenetre_prog.title("progression")
    fenetre_prog.geometry("500x425")
    label_vide_prog=tk.Label(fenetre_prog,text='')
    label_vide_prog.grid(row=0,column=0)
    label_titre_prog=tk.Label(fenetre_prog,text="VOTRE PROGRESSION",fg='red',font=("Castellar"))
    label_titre_prog.grid(row=1,column=1)
    label_vide2_prog=tk.Label(fenetre_prog,text='       ')
    label_vide2_prog.grid(row=2,column=0)
    
    graph=FigureCanvasTkAgg(progression.afficher(), master=fenetre_prog)
    canvas=graph.get_tk_widget()
    canvas.grid(row=3,column=1)
    
    label_vide3_aide_hab=tk.Label(fenetre_prog,text='')
    label_vide3_aide_hab.grid(row=4,column=0)
    quitter_aide_hab=tk.Button(fenetre_prog,text='Super !',command=fenetre_prog.destroy)
    quitter_aide_hab.grid(row=5,column=1)
    

def fct_chance(chaine):
    """Cette fonction est appelée dans la fonction choix(),
    elle affiche le résultat obtenu aux dés
    et renvoie le numéro accompagné du résultat (chance ou malchance).
    Elle diminue aussi les points de chance du joueur
    et écrit dans le journal."""
    journal.ecrit(chaine)
    bouton1.grid_remove()
    bouton1.grid_forget()
    bouton2.grid_remove()
    bouton2.grid_forget()
    bouton4.grid(row=5,column=3,columnspan=6)
    phrase2.set("Vous tentez votre chance :")
    phrase3.set("")
    phrase4.set("")
    bt4.set("Lancer les dés")
    
def fct_chance2(num_chance):
    """Cette fonction est appelée dans la fonction choix(),
    elle affiche le résultat obtenu aux dés
    et renvoie le numéro accompagné du résultat (chance ou malchance).
    Elle diminue aussi les points de chance du joueur
    et écrit dans le journal."""
    des=randint(1,6)+randint(1,6)
    
    if joueur.est_chanceux(des):
        journal.ecrit_chance(True)
        num_chance=str(num_chance)+" chance"
        phrase4.set("Vous êtes chanceux")
    else:
        journal.ecrit_chance(False)
        num_chance=str(num_chance)+" malchance"
        phrase4.set("Vous êtes malchanceux")
    
    phrase3.set("Vous obtenez "+str(des)+" !")
    bouton4.grid(row=8,column=3,columnspan=6)
    bt4.set(" suite ")
    joueur.aug_cha(-1)
    var_chance.set(joueur.get_cha())
    return num_chance


def fct_porte():
    """Cette fonction est appelée dans la fonction choix(),
    elle affiche le résultat obtenu aux dés
    et renvoie le numéro accompagné du résultat (chance ou malchance).
    Elle diminue aussi les points d'endurance du joueur si la porte résiste
    et écrit dans le journal."""
    bouton1.grid_remove()
    bouton1.grid_forget()
    bouton2.grid_remove()
    bouton2.grid_forget()
    bouton4.grid(row=5,column=3,columnspan=6)
    phrase2.set("Vous testez la résistance de la porte :")
    phrase3.set("")
    phrase4.set("")
    bt4.set("Lancer les dés")
    
def fct_porte2(num_porte):
    """Cette fonction est appelée dans la fonction choix(),
    elle affiche le résultat obtenu aux dés
    et renvoie le numéro accompagné du résultat (chance ou malchance).
    Elle diminue aussi les points d'endurance du joueur si la porte résiste
    et écrit dans le journal."""
    des=randint(1,6)+randint(1,6)
    
    if joueur.est_assez_fort(des):
        journal.ecrit_porte(True)
        num_porte=str(num_porte)+" chance"
        phrase4.set("La porte cède !")
    else:
        journal.ecrit_porte(False)
        joueur.blesser(1)
        num_porte=str(num_porte)+" malchance"
        phrase4.set("La porte résiste,\nvous perdez 1 point d'endurance")
    
    phrase3.set("Vous obtenez "+str(des)+" !")
    bouton4.grid(row=8,column=3,columnspan=6)
    bt4.set(" suite ")
    
    if joueur.est_mort():
        return "mort_porte"
    
    return num_porte




    
def choix(rep):
    """
    La fonction choix() est divisée en deux parties :
    Dans un premier temps, la fonction oriente le joueur vers le
    bon numéro en fonction de ses choix (chaque numéro correspond
    au numéro indiqué dans le livre et est affiché en haut de la 
    fenêtre ptincipale)
    
    La fonction affiche ensuite le texte correspondant au numéro
    et modifie les boutons en conséquence. Elle modifie aussi les
    caractéristiques du joueur (habilite, endurance, or, etc...)
    en fonction des situations.
    
    Lorsque le joueur rencontre un monstre, les carctéristiques
    du monstre sont enregistrées dans la partie "affichage", puis 
    la fonction combat() (qui ouvre une fenêtre de combat) est appelé
    dans la partie "orientation" si le joueur décide de combattre.
    
    La fonction remplit également le journal en fonction des choix
    que prend le joueur.

    """
    
    global num
    
    
    ############################ ORIENTATION #################################
    
    
    
    if type(num)==str:
        if "fuite" in num:
            var_endurance.set(joueur.get_end())
            label_consolas.grid_forget()
    if num==0:
        num=-1
    elif num==-1:
        if rep==1:
            var_habilite.set(joueur.get_hab())
            bouton1.config(state=tk.DISABLED,relief='sunken')
        elif rep==2:
            var_endurance.set(joueur.get_end())
            bouton2.config(state=tk.DISABLED,relief='sunken')
        elif rep==3:
            var_chance.set(joueur.get_cha())
            bouton3.config(state=tk.DISABLED,relief='sunken')
        elif rep==4:
            num=-2
            
        if bouton1['state']==tk.DISABLED and bouton2['state']==tk.DISABLED and bouton3['state']==tk.DISABLED:
            bouton4.grid(row=8,column=3,columnspan=6)
    elif num==-2:
        if rep==1: #potion d'adresse
            joueur.def_type_potion(1)
        elif rep==2: #potion de vigueur
            joueur.def_type_potion(2)
        elif rep==3: #potion de bonne fortune
            joueur.def_type_potion(3)
        elif rep==4:
            num=-3
    elif num==-3:
        num=1
    
    elif num==1:
        if rep==1:
            journal.ecrit_bifurcation("ouest")
            num=71
        elif rep==2:
            journal.ecrit_bifurcation("est")
            num=278
    elif num==278:
        if rep==1:
            num=156
        elif rep==2:
            
            num=92
    elif num==156:
        des=randint(1,6)+randint(1,6)
        if joueur.est_assez_fort(des):
            num=156.1
        else:
            num=156.2
        bt4.set(" suite ")
    elif num==156.1:
        num=343
    elif num==156.2:
        num=92
    elif num==343:
        num=92
    elif num==92:
        num=71
    elif num==71:
        num=71.2
        journal.ecrit_monstre()
        combat()
    elif num==71.2:
        if rep=="combat" : # si le combat est terminé
            num=71.3
    elif num==71.3:
        num=301
    elif num==301:
        if rep==1:
            num=82
        elif rep==2:
            num=208
    elif num==82:
        if rep==1:
            num=82.2
        elif rep==2:
            journal.ecrit_sortir()
            num=208
    elif num==82.2:
        num=82.3
        fct_chance("Je tentai de prendre la boîte sans réveiller le monstre. ")
    elif num==82.3:
        num=fct_chance2(num)
    elif num=="82.3 chance":
        num=147
    elif num=="82.3 malchance":
        num=33
    elif num==33:
        if rep==1:
            num="33 fuite"
        elif rep==2:
            num=33.2
            journal.ecrit_monstre()
            combat()
    elif num==33.2:
        if rep=='combat':
            num=33.3
    elif num==33.3:
        num=147
    elif num=="33 fuite":
        num=208
    elif num==147:
        
        num=208
    elif num==208:
        if rep==1:
            num=397
        elif rep==2:
            num=363
    elif num==397:
        if rep==1:
            num=240
        elif rep==2:
            journal.ecrit_sortir()
            num=363
    elif num==240:
        num=240.2
        journal.ecrit_monstre()
        combat()
    elif num==240.2:
        if rep=="combat":
            num=240.3
    elif num==240.3:
        num=145
    elif num==145:
        num=363
    elif num==363:
        if rep==1:
            num=370
        elif rep==2:
            num=42
    elif num==370:
        if rep==1:
            num=370.2
            journal.ecrit_combattre()
            journal.ecrit_monstre()
            combat()
        
        elif rep==2:
            journal.ecrit_sortir()
            num=42
    elif num==370.2:
        if rep=="combat":
            num=116
    elif num==116:
        if rep==1:
            num=116.2
            journal.ecrit_combattre()
            journal.ecrit_monstre()
            combat()
        
        elif rep==2:
            num="116 fuite"
    elif num=="116 fuite":
        num=42
    elif num==116.2:
        if rep=="combat":
            num=116.3
    elif num==116.3:
        num=378
    elif num==378:
        if rep==1:
            num=296
        elif rep==2:
            journal.ecrti_sortir()
            num=378.2
    elif num==296:
        num=296.2
    elif num==296.2:
        num=296.3
    elif num==296.3:
        num=296.4
    elif num==296.4:
        num=42
    elif num==378.2:
        num=42
    elif num==42:
        if rep==1:
            journal.ecrit_bifurcation("ouest")
            num=257
        elif rep==2:
            journal.ecrit_bifurcation("est")
            num=113
    elif num==257:
        if rep==1:
            num=168
        elif rep==2:
            num=293
    elif num==168:
        if rep==1:
            num=65
        elif rep==2:
            num=372
        elif rep==3:
            num=293
    elif num==65:
        if rep==1:
            num=372
        elif rep==2:
            num="65 fuite"
    elif num=="65 fuite":
        num=293
    elif num==372:
        num=372.2
        journal.ecrit_monstre()
        combat()
    elif num==372.2:
        if rep=="combat":
            num=372.3
    elif num==372.3:
        num=372.4
        journal.ecrit_monstre()
        combat()
    elif num==372.4:
        if rep=="combat":
            num=21
    elif num==21:
        if rep==1:
            num=339
        elif rep==2:
            journal.ecrit_sortir()
            num=293
    elif num==339:
        num=339.2
    elif num==339.2:
        num=339.3
    elif num==339.3:
        num=201
    elif num==201:
        num=201.2
        repas()
    elif num==201.2:
        if rep=="repas": #si le repas est terminé
            num=201.3
    elif num==201.3:
        num=201.4
        
    elif num==201.4:
        
        num=293
    elif num==293:
        num=113
    elif num==113:
        if rep==1:
            journal.ecrit_bifurcation("nord")
            num=285
        elif rep==2:
            journal.ecrit_bifurcation("est")
            num=78
    elif num==78:
        if rep==1:
            num=159
        elif rep==2:
            num=237
    elif num==159:
        num=159.2
    elif num==159.2:
        if rep==1:
            num=365
        elif rep==2:
            num=159.3
            fct_chance("Je tentai de fuir. ")
    elif num==159.3:
        num=fct_chance2(num)
    elif num=="159.3 chance":
        num=237
    elif num=="159.3 malchance":
        num=365
    elif num==365: #combat 1
        num=365.1
        journal.ecrit_monstre()
        combat()
    elif num==365.1:
        if rep=="combat":
            num=365.2
    elif num==365.2: #combat 2
        if rep==1:
            num=365.3
            journal.ecrit_monstre()
            combat()
        elif rep==2:
            num="365 fuite"
    elif num==365.3:
        if rep=="combat":
            num=365.4
            
    elif num==365.4: #combat 3
        if rep==1:
            num=365.5
            journal.ecrit_monstre()
            combat()
        elif rep==2:
            num="365 fuite"
    elif num==365.5:
        if rep=="combat":
            num=365.6
    
    elif num==365.6: #combat 4
        if rep==1:
            num=365.7
            journal.ecrit_monstre()
            combat()
        elif rep==2:
            num="365 fuite"
    elif num==365.7:
        if rep=="combat":
            num=365.8
    
    elif num==365.8: #combat 5
        if rep==1:
            num=365.9
            journal.ecrit_monstre()
            combat()
        elif rep==2:
            num="365 fuite"
    elif num==365.9:
        num=183
        
    elif num==183:
        if rep==1:
            num=266
        elif rep==2:
            journal.ecrit_sortir()
            num=183.2
    elif num==266:
        num=266.2
    elif num==266.2:
        num=266.3
    elif num==266.3:
        num=285
    elif num==283.2:
        num=285
    elif num=="365 fuite":
        num=237
    elif num==237:
        num=285
        
    elif num==285:
        if rep==1:
            num=213
            fct_porte()
        elif rep==2:
            num=314
    elif num==213:
        num=fct_porte2(num)
    elif num=="213 chance":
        num=36
    elif num=="213 malchance":
        num=314
    elif num==36:
        if rep==1:
            num=263
        elif rep==2:
            num=353
    elif num==263:
        num=263.2
    elif num==263.2:
        num=263.3
    elif num==263.3:
        num=263.4
    elif num==263.4:
        num=314
    elif num==353:
        num=314
    elif num==314:
        if rep==1:
            num=223
        elif rep==2:
            num=300
    elif num==223:
        if rep==1:
            num=53
            fct_porte()
        elif rep==2:
            num=300
    elif num==53:
        num=fct_porte2(num)
    elif num=="53 chance":
        num=155
    elif num=="53 malchance":
        num=300
    elif num==155:
        num=155.2
    elif num==155.2:
        num=300
    elif num==300:
        if rep==1:
            num=102
        elif rep==2:
            num=303
            phrase2.set("Cela ne vous concerne pas. Il ne manquerait plus que vous soyez vous\naussi torturé pour avoir voulu porter secours à un inconnu!")
    elif num==102:
        if rep==1:
            num=303
            journal.ecrit_sortir()
            phrase2.set("Vous retournez dans le couloir. Les tortionnaires ont du juger plus\namusant de continuer leur occupation que de vous suivre\npuisqu'aucun d'eux ne sort à son tour.")
        elif rep==2:
            num=19
        elif rep==3:
            num=68
    elif num==19:
        
        num=19.2
        journal.ecrit_monstre()
        combat()
    elif num==19.2:
        if rep=="combat":
            num=19.3
    elif num==19.3:
        num=19.4
        journal.ecrit_monstre()
        combat()
    elif num==19.4:
        if rep=="combat":
            num=317
    elif num==317:
        num=303
        phrase2.set("Vous retournez dans le couloir")
    elif num==68:
        num=68.2
    elif num==68.2:
        num=303
        phrase2.set("Vous estimez préférable de partir et retournez dans le couloir.\nVous ne trouvez aucune trace des deux lutins.")
    elif num==303:
        if rep==1:
            num=243
        elif rep==2:
            num=128
    elif num==243:
        num=243.2
    elif num==243.2:
        num=243.3
    elif num==243.3:
        num=243.4
    elif num==243.4:
        num=128
    elif num==128:
        num=128.2
    elif num==128.2:
        num=128.3
            
    
    
    if type(num)==str:
        if "fuite" in num:
            journal.ecrit_fuite()
            joueur.blesser(2)
            phrase2.set("")
            phrase3.set(monstre.fait_fuire())
            phrase4.set("")
            phrase_consolas.set("[Vous perdez deux points d'endurance]")
            label_consolas.grid(row=6,column=3,columnspan=6)
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            bt4.set(" suite ")
        
        elif num=="mort_porte":
            num="mort_porte2"
            
        elif num=="mort_porte2":
            num="mort_porte3"
            phrase2.set("")
            phrase3.set("Vous êtes mort en essayant d'enfoncer une porte.")
            phrase4.set("")
            
        elif num=="mort_porte3":
            phrase3.set("Sans commentaire.")
            bouton4.config(command=fenetre_smf.destroy)
            bt4.set("Quitter le jeu")
            
            
            
            
    ############################# AFFICHAGE ##################################
    
    
    
    
    elif num==-1:
        phrase1.set("Avant de commencer, nous allons déterminer vos forces et faiblesses :")
        phrase2.set('habilité')
        phrase3.set("endurance")
        phrase4.set("chance")
        bouton1.config(bg='#eee')
        bouton2.config(bg='#f0f0f0')
        bouton3.config(bg='#f0f0f0')
        bt1.set("Lancer les dés")
        bt2.set("Lancer les dés")
        bt3.set("Lancer les dés")
        bt4.set(" suite ")
        label_phrase2.grid(row=5,column=3,columnspan=2)
        label_phrase3.grid(row=5,column=5,columnspan=2)
        label_phrase4.grid(row=5,column=7,columnspan=2)
        bouton1.grid(row=6,column=3,columnspan=2)
        bouton2.grid(row=6,column=5,columnspan=2)
        bouton3.grid(row=6,column=7,columnspan=2)
    elif num==-2:
        phrase1.set("Super ! Vos points de départ ont bien été enregistrés !\nMais attention, ils risquent de varier tout au long de votre aventure.")
        phrase2.set("Vous allez donc pouvoir choisir une de ces trois potions :")
        phrase3.set("la potion d'adresse vous rend vos points d'habilité,\nla potion de vigueur vous rend vos points d'endurance,\nla potion de bonne fortune vous rend vos points de chance, auquels elle ajoute 1.")
        phrase4.set('')
        label_phrase2.grid(row=4,column=3,columnspan=6)
        label_phrase3.grid(row=5,column=3,columnspan=6)
        label_phrase4.grid(row=8,column=3,columnspan=6)
        label_phrase4.config(fg='red')
        bt1.set("potion d'adresse")
        bt2.set("potion de vigueur")
        bt3.set("potion de bonne fortune")
        bt4.set("Valider")
        bouton1.grid(row=7,column=3,columnspan=2)
        bouton2.grid(row=7,column=5,columnspan=2)
        bouton3.grid(row=7,column=7,columnspan=2)
        bouton1.config(state=tk.NORMAL,relief='raised',bg='red')
        bouton2.config(state=tk.NORMAL,relief='raised',bg='green')
        bouton3.config(state=tk.NORMAL,relief='raised',bg='blue')
        bouton4.grid_forget()
        if joueur.get_type_potion()=="potion d'adresse":
            phrase4.set("Vous avez choisi la potion d'adresse")
        elif joueur.get_type_potion()=='potion de vigueur':
            phrase4.set("Vous avez choisi la potion de vigueur")
        elif joueur.get_type_potion()=='potion de bonne fortune':
            phrase4.set("Vous avez choisi la potion de bonne fortune")
        if joueur.get_type_potion()!='':
            bouton4.grid(row=9,column=3,columnspan=6)
    elif num==-3:
        bouton_potion.config(state=tk.NORMAL,relief='raised')
        phrase1.set("Voilà votre "+joueur.get_type_potion()+" !\nVous pouvez l'utiliser à tout moment en cliquant sur le bouton 'potion'.")
        phrase2.set("Attendez ! Ne partez pas si vite !\nTenez, une épée et un bouclier pour faire face au danger.")
        phrase3.set("Prenez aussi ces provisions et ces pièces d'or. Vous risquez d'en avoir besoin dans la montagne.")
        phrase4.set("Sur ce, bon voyage!")
        label_phrase4.config(fg='black')
        label_phrase4.grid(row=6,column=3,columnspan=6)
        bt4.set("Partir à l'aventure !")
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton3.grid_remove()
        bouton3.grid_forget()
        bouton4.grid(row=8,column=3,columnspan=6)
        var_potion.set(joueur.get_potion())
    elif num==1:
        journal.ecrit("\n        Au bout de deux jours de marche, je parvins enfin à la montagne de feu. Je m'enfonçai dans la montagne, plein d'espoir et de détermination. ")
        var_or.set(joueur.get_or())
        var_provisions.set(joueur.get_prov())
        phrase1.set("n°1")
        phrase2.set("La montagne se tient devant vous, menaçante.")
        phrase3.set("En face de vous, dans son flanc, se découpe une ouverture sombre :\n l'entrée de la montagne de feu, le début de votre aventure.")
        phrase4.set("Sans hésitation, vous vous enfoncez dans les ténèbres.\nAu bout de quelques mètres, vous arrivez à une bifurcation.")
        bt1.set("Irez-vous vers l'ouest?")
        bt2.set("Ou vers l'est?")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid(row=8,column=3,columnspan=3)
        bouton2.grid(row=8,column=6,columnspan=3)
        
        ##########pièce 0
        
        progression.actualiser()
        
    elif num==278:
        journal.ecrit("Le passage menait à une porte fermée à clé. ")
        phrase1.set("n°278")
        phrase2.set("Le passage aboutit bientôt à une porte fermée à clé.")
        phrase3.set("Vous collez votre oreille contre le panneau mais vous n'entendez rien.")
        phrase4.set("")
        bt1.set("Essayer d'enfoncer la porte")
        bt2.set("Rebrousser chemin")
    elif num==156:
        phrase1.set("n°156")
        phrase2.set("Vous essayer d'enfoncer la porte à coup d'épaule.")
        phrase3.set("Jetez deux dés.")
        phrase4.set("Pour ouvrir la porte, il vous faut obtenir un nombre inférieur\nou égal à vos points d'habilité.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set("Lancer les dés")
    elif num==156.1:
        phrase3.set("Bravo, vous avez obtenu "+str(des)+" !")
        phrase2.set("")
        phrase4.set("")
    elif num==156.2:
        phrase3.set("Vous obtenez "+str(des)+".")
        phrase2.set("")
        phrase4.set("Vous frottez votre épaule endolorie avant de retourner au croisement.")
        
    elif num==343:
        journal.ecrit("Mais la porte cachait un fossé dans lequel je tombai. ")
        phrase1.set("n°343")
        phrase2.set("La porte s'ouvre et vous tombez la tête la première dans une fosse.")
        phrase3.set("Vous perdez 1 point d'endurance.")
        phrase4.set("Vous vous hissez hors de la pièce en prenant la direction de l'ouest.")
        joueur.blesser(1)
    elif num==92:
        journal.ecrit("Je rebroussai chemin. De retour à la bifurcation, je m'engageai vers l'ouest. ")
        var_endurance.set(joueur.get_end())
        phrase1.set("n°92")
        phrase2.set("Vous êtes de retour au croisement.")
        phrase3.set("Vous regardez sur votre gauche vers l'entrée de la caverne.")
        phrase4.set("Mais vous marchez droit devant vous, vers l'ouest")
        bt4.set("suite")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
    elif num==71:
        journal.ecrit("\n\n        Je rencontrai le premier monstre de la montagne. Il montait la garde près d'une guérite. Il s'agissait d'un farfadet. Il me fallu le combattre. ")
        monstre.nouveau('FARFADET',8,10,["Farfadet s'élance","Le farafadet vous frappe de toutes ses forces"],particularite="premier monstre")
        phrase1.set("n°71")
        phrase2.set("Le passage forme un virage à droite en direction du nord.")
        phrase3.set("Dans l'angle du passage, une étrange créature dort dans une guérite.\nAlors que vous passez devant lui, il ouvre les yeux.")
        phrase4.set("Vous n'avez pas le choix, il vous faut le combattre.")
        bt4.set("Engager le combat")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        
    elif num==71.3:
        phrase4.set("")
        if joueur.est_mort():
            phrase2.set("")
            phrase3.set("Quel dommage, vous êtes mort!")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("Le passage tournait ensuite à droite, vers l'est. ")
            phrase2.set("Le farfadet s'écroule sur le sol")
            phrase3.set("Vous continuez votre chemin le long du passage")
            bt4.set(" suite ")
    elif num==301:
        phrase1.set("n°301")
        phrase2.set("Sur votre gauche se trouve une porte de bois brut grossièrement taillé.")
        phrase3.set("Vous tendez l'oreille et percevez une sorte de ronflement.")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bt1.set("Ouvrir la porte")
        bt2.set("Continuer d'avancer")
    elif num==82:
        journal.ecrit("\n\n        Au bout de quelque mètres, j'arrivai à une porte logée dans le mur ouest. Dans la pièce règnait une forte odeur. Au fond de la pièce dormait un farfadet et, entre le monstre et moi, se dressait une table bancale sous laquelle était entreposée une boîte en bois. ")
        pieces_visitees.append("pièce 1")
        phrase1.set("n°82")
        phrase2.set("La porte s'ouvre sur une petite pièce dans laquelle règne une forte odeur.")
        phrase3.set("Au milieu se trouve une table bancale.\nSous celle-ci, une petite boîte en bois est posée à même le sol.")
        phrase4.set("Dans un coin, une créature semblable à celle que vous venez de terrasser dort à poingts fermés.")
        bt1.set("Tenter de prendre la boîte")
        bt2.set("Regagner le couloir")
    elif num==82.2:
        phrase2.set("Vous rampez sur le sol.")
        phrase3.set("Il vous faut tenter votre chance :")
        phrase4.set("Si vous êtes chanceux, vous vous approchez de la table sans dommage.\nSinon, la créature se réveille.")
        bt4.set("Tentez votre chance")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
    elif num==33:
        monstre.nouveau('FARFADET',6,4,["Le farfadet vous mord le bras.","Vous sentez les dents acérées du monstre s'enfoncer dans votre épaule.","Le farfadet vous met une droite.\nVous ne l'aviez pas vu venir, celle-là!"],fuite="Vous vous enfuyez sans demander votre reste mais alors que vous fermez la porte,\n la créature vous lance une bouteille remplie d'une boisson nauséabonde qui vous atteint malgré vous.")
        phrase1.set("n°33")
        phrase2.set("La créature se réveille en sursaut et bondit sur vous.")
        phrase3.set("Vous pouvez prendre la fuite, mais votre adversaire\naura l'occasion de vous blesser")
        phrase4.set("et vous perdrez deux points d'endurance.")
        bt1.set("  Fuir  ")
        bt2.set("Combattre")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
    elif num==33.3:
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        if joueur.est_mort():
            phrase2.set("")
            phrase3.set("Vous sentez les crocs acérés du farfadet se planter dans votre gorge.")
            phrase4.set("Quel dommage, vous êtes mort!")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            phrase2.set("Vous tranchez la tête du farfadet de votre épée.")
            phrase3.set("Vous la voyez rouler sur le sol avant de s'immobiliser.")
            phrase4.set("Vous vous accroupissez devant la table.")
            bt4.set(" suite ")
    elif num==147:
        journal.ecrit("Je pris la boîte et l'ouvrit. A l'intérieur, je trouvai un pièce d'or que j'emportai avec moi. ")
        phrase1.set("n°147")
        phrase2.set("Vous récupérez la boîte et l'ouvrez.")
        phrase3.set("A l'intérieur, vous trouvez une pièce d'or.\nVous prenez 2 points de chance.")
        phrase4.set("Vous sortez de la pièce.")
        joueur.aug_cha(2)
        joueur.aug_or(1)
    elif num==208:
        var_chance.set(joueur.get_cha())
        var_or.set(joueur.get_or())
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        phrase1.set("n°208")
        phrase2.set("Vous continuez vers le nord.")
        phrase3.set("Un peu plus loin, dans le mur ouest, vous trouvez une autre porte.")
        phrase4.set("Vous collez votre oreille contre le panneau mais vous n'entendez rien.")
        bt1.set("Franchir la porte")
        bt2.set("Poursuivre votre route")
        
        ##########pièce 1
        progression.actualiser()
        
        
    elif num==397:
        journal.ecrit("\n\n        Un peu plus loin, j'entrai dans un pièce sur ma gauche. Elle était vide, à l'exception d'un table rudimentaire au centre de la pièce. Sous celle-ci se trouvait une petite boîte en bois. ")
        pieces_visitees.append("pièce 2")
        phrase1.set("n°397")
        phrase2.set("Vous pénetrez dans une pièce dénuée de meubles,\nà l'exeption d'une table rudimentaire, au centre de la pièce.")
        phrase3.set("Sous la table, vous apercevez une petite boîte en bois.")
        phrase4.set("Vous avez le choix :")
        bt1.set("Ouvrir la boîte")
        bt2.set("Quitter la pièce")
    elif num==240:
        journal.ecrit("Je pris la boîte et l'ouvrit. Un serpent en jaillit.")
        monstre.nouveau('SERPENT',5,2,['Le serpent vous mord le doigt, vous secouez la main pour le faire lâcher prise, en vain'])
        pieces_visitees.append("boîte serpent")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        phrase1.set("n°240")
        phrase2.set("La boîte est légère mais quelque chose fait du bruit à l'intérieur.")
        phrase3.set("Vous soulevez le couvercle et un serpent en jaillit.")
        phrase4.set("Il vous faut le combattre.")
        bt4.set("Engager le combat")
    elif num==240.3:
        if joueur.est_mort():
            phrase2.set("")
            phrase3.set("Le serpent vous attaque à la gorge, vous ne parvenez pas à l'éviter.")
            phrase4.set("Vous sentez la vie quitter lentement votre corps.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            phrase2.set("Le serpent rampe lentement au sol, il semble affaibli par votre attaque.")
            phrase3.set("Vous profitez de l'occasion et lui tranchez la tête de votre épée.")
            phrase4.set("Son corps continue de se tortiller un moment avant de retomber sur le sol, inerte.")
            bt4.set(" suite ")
    elif num==145:
        journal.ecrit("Une fois le serpent tué, je récupérai la boîte. Je trouvai à l'intérieur une petite clé de bronze portant le numéro '99' que je rangeai dans mon sac. ")
        phrase1.set("n°145")
        phrase2.set("Vous reprenez la boîte, tombée à terre et regardez ce qu'elle contient.\nAl'intérieur, vous trouvez une clé de bronze sur laquelle est gravé le nombre '99'.")
        phrase3.set("")
        phrase_consolas.set("[l'objet 'clé n°99' a été ajouté à votre inventaire]")
        label_consolas.grid(row=5,column=3,columnspan=6)
        phrase4.set("Vous gagnez 1 point de chance. Vous quittez la pièce.")
        joueur.aug_cha(1)
        joueur.add_inv("clé n°99"," : Que peut bien ouvrir cette clé?")
    elif num==363:
        var_chance.set(joueur.get_cha())
        label_consolas.grid_forget()
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        phrase1.set("n°363")
        phrase2.set("Un peu plus loin, toujours dans le mur ouest, vous trouvez une troisième porte.")
        phrase3.set("Vous grimacez en entendant des voix chanter si fort et si faux\nque jamais vous n'auriez cru possible de parvenir à une telle cacophonie.")
        phrase4.set("")
        bt1.set("Entrer pour voir qui\nproduit ce vacarme")
        bt2.set("Continuer tout droit,\nindifférent au bruit")
        
        ##########pièce 2
        progression.actualiser()
        
        
    elif num==370:
        monstre.nouveau('FARFADET 1',5,4,["Le farfadet plante don poignard dans votre brase","Le poignard du farfadet fend l'air. Vous êtes blessé","Le farfadet se jette sur vous, vous l'évitez de justesse : sa lame vous entaille l'oreille."],particularite='ivresse')
        phrase1.set("n°370")
        if "pièce 1" in pieces_visitees and "pièce 2" in pieces_visitees:
            journal.ecrit("\n\n        Plus loin dans le couloir, j'entrai dans une troisième pièce semblable aux deux précédentes. ")
            phrase2.set("Vous entrez dans un pièce, en tout point semblable aux deux précédentes.")
            phrase3.set("Sans surprise, vous apercevez une boîte sous la table à laquelle sont assis deux farfadets.")
        elif "pièce 1" in pieces_visitees or "pièce 2" in pieces_visitees:
            journal.ecrit("\n\n        Plus loin dans le couloir, j'entrai dans une pièce semblable à celle que je venais de visiter. ")
            phrase2.set("Vous entrez dans un pièce, en tout point semblable à celle que vous venez de visiter.")
            phrase3.set("Vous trouvez à nouveau une boîte sous la table au centre de la pièce.\nMais elle est gardée par deux farfadets, assis autour de la table.")
        else:
            journal.ecrit("\n\n        Plus loin dans le couloir, j'entrai dans une pièce dénuée de meubles, hormis une table de bois au centre de la pièce sous laquelle était posée à même le sol ")
            phrase2.set("Vous entrez dans une petite pièce sale et en désordre.\nUne table se dresse au centre de la pièce. Il y a sous celle-ci une petite boîte.")
            phrase3.set("Autour de cette même table sont assis deux créatures semblables\nà celle qui dormait dans la guérite.")
        journal.ecrit("Deux farfadets étaient attablés autour de la table et buvaient une sorte de grog. ")
        phrase4.set("Ils boivent une espèce de grog et à leur regard vide,\nvous devinez sans peine qu'ils sont ivres.")
        bt1.set("Tirer votre épée et\nbondir sur eux")
        bt2.set("Sortir et courir\nle long du passage.")
    elif num==116:
        if joueur.est_mort():
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            phrase2.set("")
            phrase3.set("Le farfadet vous plante son poignard dans le coeur. Vous vous écroulez.")
            phrase4.set("Quel dommage, vous êtes mort!")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else :
            journal.ecrit("Le premier farfadet était mort. Le deuxième me faisait face. ")
            monstre.nouveau('FARFADET 2',5,5,["Le farfadet enfonce son sabre dans votre bras.","Malgré son ivresse, le farfadet manie son sabre à la perfection. Sa lame vous entaille le flanc.","Le farfadet se jette sur vous, vous parez son attaque de votre épée mais vous êtes projetté à terre."],fuite="Vous quittez la pièce en trompe mais le farfadet a le temps de vous blesser dans le dos.",particularite="ivresse")
            phrase1.set("n°116")
            phrase2.set("Vous avez terrassé votre ennemi. Mais le deuxième farfadet est déjà sur vous!")
            phrase3.set("Vous pouvez vous enfuir, mais si vous tournez le dos à votre ennemi,\nil aura la possibilité de vous attaquer et vous perdrez deux points d'endurance")
            phrase4.set("")
            bt1.set("Combattre")
            bt2.set(" Fuir ")
    elif num==116.3:
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        if joueur.est_mort():
            phrase2.set("")
            phrase3.set("Le sabre du farfadet vient se loger dans votre coeur.")
            phrase4.set("Le monstre retire son arme, l'air satisfait.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            phrase2.set("Les cadavres des deux farfadets gisent sur le sol.")
            phrase3.set("Vous essuyez votre épée ensanglantée sur la paillasse située au fond de la salle,")
            phrase4.set("sur laquelle son propriétaire ne dormira plus jamais.")
            bt4.set(" suite ")
    elif num==378:
        journal.ecrit("Je parvins à tuer le deuxième farfadet. ")
        phrase1.set("n°378")
        phrase2.set("Vous vous emparrez de la boîte qui se trouve sous la table.")
        phrase3.set("Sur le couvercle est fixée une petite plaque de cuivre sur laquelle on peut lire :")
        phrase4.set('" Farrigo Di Maggio "')
        label_phrase4.config(font=("papyrus"))
        bt1.set("Ouvrir la boîte")
        bt2.set("Quitter la pièce")
        bouton1.grid()
        bouton2.grid()
        bouton4.grid_remove()
        bouton4.grid_forget()
    elif num==296:
        label_phrase4.config(font=("TkDefaultFont"))
        phrase1.set("n°296")
        phrase2.set("La boîte contient un petit livre en cuir portant le titre suivant :\n'Comment le dragon fabrique et souffle le feu'")
        phrase3.set("Vous vous empressez de le lire.")
        phrase4.set("Il s'agit d'une oeuvre autobiographique d'un certain Di Maggio\nqui aurait découvert le moyen de neutraliser les dragons.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
    elif num==296.2:
        phrase2.set("Un message est adressé au lecteur à la fin du livre :")
        label_phrase3.config(font=("papyrus"))
        label_phrase4.config(font=("papyrus"))
        phrase3.set("'' A toi qui tiens entre tes mains le fruit de mes intensives recherches ,\nje te confie le pouvoir que, ma vie durant, j'ai tant convoité.")
        phrase4.set("Puisses-tu à bien l'utiliser pour combattre le mal\nqui depuis l'aube des temps sévit sur le monde.")
        fenetre_smf.geometry('660x350')
    elif num==296.3:
        label_phrase2.config(font=("papyrus"))
        phrase2.set("Voci les mots qu'ils te faudra prononcer\nquand à combattre le dragon tu sera mené :")
        phrase3.set("     Ekil Erif\n     Ekam Erif")
        phrase4.set("     Erif Erif\n     Di Maggio ''")
    elif num==296.4:
        journal.ecrit("J'ouvrai la boîte. Il y avait à l'intérieur un livre en cuir qui enseignait l'art de combattre le dragon et que je mis immédiatement dans mon sac. Je quittai ensuite la pièce. ")
        fenetre_smf.geometry('660x300')
        label_phrase2.config(font=("TkDefaultFont"))
        label_phrase3.config(font=("TkDefaultFont"))
        label_phrase4.config(font=("TkDefaultFont"))
        phrase2.set("Après avoir fini votre lecture, vous rangez le livre dans votre sac.")
        phrase3.set("")
        phrase4.set("Vous quittez ensuite la pièce, heureux de votre découverte.")
        label_consolas.grid(row=5,column=3,columnspan=6)
        phrase_consolas.set("[l'objet 'Livre de Farrigo Di Maggio' a été ajouté à votre inventaire]") 
        joueur.add_inv("Livre de Farrigo Di Maggio"," : Il renferme le secret pour terrasser un dragon.")
    elif num==378.2:
        label_phrase4.config(font=('TkDefaultFont'))
        if "boîte serpent" in pieces_visitees:
            phrase2.set("Vous avez une mauvaise expérience des boîtes.\nAussi, conscient des risques qu'elles représentent et")
            phrase3.set("résolumment déterminé à ne pas écourter votre espérence de vie,\nvous préférerez passer votre chemin.")
        else:
            phrase2.set("Vous n'avez pas envie d'encombrer votre sac de babioles inutiles.")
            phrase3.set("Sans compter qu'il pourrait s'agir d'un piège.")
        phrase4.set("Vous quittez la pièce et continuez votre progression vers le nord.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
    elif num==42:
        label_consolas.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bouton4.grid_remove()
        bouton4.grid_forget()
        phrase1.set("n°42")
        phrase2.set("Vous arrivez enfin au bout du couloir.")
        phrase3.set("Vous vous trouvez à un croisement.")
        phrase4.set("")
        bt1.set("Aller à l'ouest")
        bt2.set("Aller à l'est")
        
        
        ##########pièce 3
        progression.actualiser()
        
        
    elif num==257:
        journal.ecrit("Le passage aboutissait à une porte fermée.")
        phrase1.set("n°257")
        phrase2.set("Le passage aboutit à une porte de bois.")
        phrase3.set("Vous percevez des cris de colère provenant de l'intérieur")
        phrase4.set("Allez-vous entrer pour voir ce qu'il se passe?")
        bt1.set("Entrer")
        bt2.set("Faire\ndemi-tour")
    elif num==293:
        journal.ecrit("Je retournai à la bifurcation où je pris la direction de l'est. ")
        label_consolas.grid_forget()
        phrase1.set("n°293")
        phrase2.set("Vous retournez à la bifurcation.")
        phrase3.set("Là, vous prenez la direction de l'est.")
        phrase4.set("")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton3.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==168:
        journal.ecrit("J'ouvrai la porte et pénétrai dans une grande pièce au centre de laquelle trônait un coffre. Deux farfadets se tenaient au fond de la salle. Celui qui semblait être le chef était occupé à battre son serviteur. ")
        
        monstre.nouveau('CHEF DES FARFADETS',7,6,["Le Chef des farfadets fait claquer son fouet.","Le fouet du farfadet vous atteint au visage. Aîe, quelle douleur cuisante!"],fuite="Vous courez vers la porte.\nLe fouet du chef vous atteint mais vous ne vous arrêtez pas.")
        phrase1.set("n°168")
        phrase2.set("Un coffre trône au centre de la pièce dans laquelle vous pénetrez.")
        phrase3.set("Dans un coin se trouve le chef des farfadets, que vous reconnaissez à son accoutrement.")
        phrase4.set("Un fouet à la main, il est occupé à corriger son serviteur qui gémit sous les coups.")
        bouton1.grid(row=8,column=3,columnspan=2)
        bouton2.grid(row=8,column=5,columnspan=2)
        bouton3.grid(row=8,column=7,columnspan=2)
        bt1.set("Attaquer le chef")
        bt2.set("Les attaquer\ntous les deux")
        bt3.set("Quitter le pièce")
    elif num==65:
        journal.ecrit("Je décidai d'attaquer le chef, mais son serviteur était lui aussi résolu à m'attaquer. J'affrontai désormais deux adversaires. ")
        phrase1.set("n°65")
        phrase2.set("Alors que vous attaquez le Chef des farfadets, son serviteur attrape un gourdin.")
        phrase3.set("Mais c'est sur VOUS qu'il bondit. Vous avez désormais deux adversaires.")
        phrase4.set("Vous pouvez fuir mais ils auront le temps de vous attaquer et vous perdrez deux points d'endurance.")
        bouton3.grid_forget()
        bouton1.grid(row=8,column=3,columnspan=3)
        bouton2.grid(row=8,column=6,columnspan=3)
        bt1.set("Poursuivre le combat")
        bt2.set("Prendre la fuite")
    elif num==372:
        journal.ecrit("Je m'attaquai d'abord au chef. ")
        phrase1.set("n°372")
        phrase2.set("Le combat s'engage!")
        phrase3.set("Vous affrontez d'abord le chef des farfadets.")
        phrase4.set("")
        bouton3.grid_forget()
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set("Combattre")
    elif num==372.3:
        if joueur.est_mort():
            phrase2.set("Le Chef des farfadets passe derrière vous et vous étrangle à l'aide de son fouet.")
            phrase3.set("Vous sentez la vie vous quitter.")
            phrase4.set("Quel dommage! vous êtes mort!")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("J'affrontai ensuite le serviteur. ")
            monstre.nouveau('SERVITEUR',5,3,["Le farfadet fait tourner son gourdin, l'air menaçant.","Le farfadet abat son gourdin. Vous êtes étourdi.","Le farfadet vous met un coup de gourdin dans les côtes. Vous avez le souffle coupé."])
            phrase2.set("Vous avez terrassé le chef des farfadets.")
            phrase3.set("Mais son serviteur, fou de rage, se rue sur vous.")
            phrase4.set("")
            bt4.set("Continuer le combat")
    elif num==21:
        if joueur.est_mort():
            phrase2.set("Vous recevez un coup de gourdin sur la tête.")
            phrase3.set("Vous entendez comme un craquement avant de perdre connaissance.")
            phrase4.set("Vous n'y survivrez pas.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("Les deux farfadets étaient morts, je m'approchai du coffre. ")
            phrase1.set("n°21")
            phrase2.set("Les deux farfadets sont à terre. Vous vous approchez du coffre.\nIl est solide, fait de chêne et de fer.")
            if joueur.possede("clé n°99"):
                journal.ecrit("J'essayai de l'ouvrir avec la clé que j'avais trouvé plus tôt, mais je ne parvins pas à la rentrer dans la serrure. ")
                phrase3.set("Vous essayez la clé que vous avez trouvé dans la boîte\nau serpent, sans succès")
                phrase4.set("Voulez-vous essayer de briser la serrure avec votre épée?")
            else:
                journal.ecrit("Il était malheureusement fermé à clé. ")
                phrase3.set("Voulez-vous essayer de briser la serrure avec votre épée?")
                phrase4.set("")
            bouton1.grid(row=8,column=3,columnspan=3)
            bouton2.grid(row=8,column=6,columnspan=3)
            bouton4.grid_remove()
            bouton4.grid_forget()
            bt1.set("Tenter le coup")
            bt2.set("Partir")
    elif num==339:
        phrase1.set("n°339")
        phrase2.set("La serrure n'est guère solide :\nelle saute immédiatement et attérrit quelques mètres plus loin.")
        phrase3.set("Il y a un bon nombre de pièces d'or à l'intérieur. Vous y trouvez également un gant de soie noire\net une petite bouteille noire munie d'un bouchon de verre.")
        phrase4.set("Mais alors que vous admirez ce trésor, vous entendez un déclic :\nUne fléchette empoisonnée vous atteint à l'estomac.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==339.2:
        phrase2.set("Lancez un dé pour déterminer l'efficacité du poison.")
        phrase3.set("")
        phrase4.set("")
        bouton4.grid(row=5,column=3,columnspan=6)
        bt4.set("Lancer un dé")
    elif num==339.3:
        des=randint(1,6)
        joueur.blesser(des)
        phrase3.set("Vous obtenez "+str(des)+".")
        label_consolas.grid(row=6,column=3,columnspan=6)
        phrase_consolas.set("[Vous perdez "+str(des)+" point(s) d'endurance]")
        bouton4.grid(row=8,column=3,columnspan=6)
        bt4.set(" suite ")
    elif num==201:
        var_endurance.set(joueur.get_end())
        label_consolas.grid_forget()
        if joueur.est_mort():
            phrase2.set("Le poison fait progressivement son effet.")
            phrase3.set("Votre vue se trouble, votre corps vous parait lourd.")
            phrase4.set("Vous sombrez dans un sommeil duquel vous ne vous réveillerez jamais.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("Je réussis à l'ouvrir d'un coup d'épée mais au même moment, une flechette empoisonnée m'atteignit et je fus grandement affaibli. ")
            phrase1.set("n°201")
            phrase2.set("Vous vous effondrez au sol. Vous retirez la flechette et pansez la blessure.")
            phrase3.set("Vous êtes affaibli par le combat, et cette fléchette n'arrange rien.")
            phrase4.set("Vous pouvez, si vous le souhaîtez, prendre un repas")
            bt4.set("Prendre un repas")
    elif num==201.3:
        journal.ecrit("\n        Le coffre contenait des pièces d'or, un gant de soie noire et une potion d'invisibilité. ")
        var_endurance.set(joueur.get_end())
        phrase2.set("Vous examinez avec plus d'attention le contenu du coffre.\nVous comptez les pièces d'or : il y en a 25 en tout.")
        phrase3.set("Vous lisez l'étiquette de la bouteille de la bouteille. Elle contient\nune dose de potion d'invisibilité. Le gant reste un mystère.")
        phrase4.set("Vous ne pouvez prendre qu'une seule de ces trouvailles :")
        bouton1.grid(row=8,column=3,columnspan=2)
        bouton2.grid(row=8,column=5,columnspan=2)
        bouton3.grid(row=8,column=7,columnspan=2)
        bouton4.grid_remove()
        bouton4.grid_forget()
        bt1.set("25 pièces d'or")
        bt2.set("potion d'invisibilité")
        bt3.set("gant en soie")
    elif num==201.4:
        if rep==1:
            journal.ecrit("J'emportai les pièces avec moi. ")
            phrase2.set("Vous vous jetez sur les pièces d'or.")
            label_consolas.grid(row=5,column=3,columnspan=6)
            phrase_consolas.set("[transfert effectué avec succès]")
            joueur.aug_or(25)
            var_or.set(joueur.get_or())
        elif rep==2:
            journal.ecrit("J'emportai la potion avec moi. ")
            phrase2.set("Vous fourrez la bouteille dans votre sac.")
            label_consolas.grid(row=5,column=3,columnspan=6)
            phrase_consolas.set("[l'objet 'potion d'invisibilité' a été ajouté à votre inventaire]")
            joueur.add_inv("potion d'invisibilité"," : elle contient une seule et unique dose.")
        elif rep==3:
            journal.ecrit("J'emportai le gant avec moi. ")
            phrase2.set("Vous prenez le gant et le rangez dans votre sac.")
            label_consolas.grid(row=5,column=3,columnspan=6)
            phrase_consolas.set("[l'objet 'gant de soie noire' a été ajouté à votre inventaire]")
            joueur.add_inv('gant de soie noie'," : vous ignorez son utilité, mais qu'est-ce qu'il est doux au toucher!")
        phrase3.set("")
        phrase4.set("Vous quittez la pièce.")
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton3.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==113:
        phrase1.set("n°113")
        phrase2.set("Vous arrvez à une autre bifurcation.")
        phrase3.set("Vous pouvez aller au nord ou poursuivre vers l'est.")
        phrase4.set("")
        bouton1.grid(row=8,column=3,columnspan=3)
        bouton2.grid(row=8,column=6,columnspan=3)
        bouton4.grid_remove()
        bouton4.grid_forget()
        bt1.set("Aller au nord")
        bt2.set("Aller à l'est")
        
        ##########pièce 4
        progression.actualiser()
        
        
    elif num==78:
        journal.ecrit("J'arrivai à une porte. ")
        phrase1.set("n°78")
        phrase2.set("Vous arrivez à une massive porte de bois.")
        phrase3.set("Vous entendez des marmonnements et des bruits de marmites")
        phrase4.set("et de casseroles qui s'entrechoquent.")
        bt1.set("Franchir la porte")
        bt2.set("Rebrousser chemin")
    elif num==159:
        journal.ecrit("Elle débouchait sur cuisine où mangeaient 5 farfadets. ")
        phrase1.set("n°159")
        phrase2.set("Vous ouvrez la porte et découvrez une vaste pièce meublée\nd'une grande table et de meubles de cuisine.")
        phrase3.set("Il s'agit de la salle à manger des farfadets.")
        phrase4.set("Cinq de ces créatures sont attablées et dégustent une soupe de gésiers de rats.\nIls sont si absorbés par leur dispute pour savoir qui pourra ronger\nles os au fond de la marmite qu'ils ne vous ont pas vu.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==159.2:
        phrase2.set("Vous pouvez en profitez pour les attaquer par surprise")
        phrase3.set("mais si vous trouvez totalement stupide de vous attaquer\nà une horde d'adversaires redoutables sans raison,")
        phrase4.set("vous pouvez tenter votre chance pour fuir sans vous faire remarquer.")
        bouton1.grid()
        bouton2.grid()
        bouton4.grid_remove()
        bouton4.grid_forget()
        bt1.set("Les attaquer")
        bt2.set("Tenter de fuir")
    elif num==365:
        journal.ecrit("Je dus les combattre un par un. Le premier était armé d'une spatule, le second d'une louche, le troisième d'un couteau de cuisine, le quatrième d'un rouleau à patisserie et le dernier d'une marmite. ")
        monstre.nouveau('FARFADET 1',7,4,["Le farfadet vous frappe de sa spatule.","Vous recevez un grand coup de spatule sur la tête.","Le farfadet abat sa spatule sur vous sans pitié."])
        phrase1.set("n°365")
        phrase2.set("Les farfadets vous attaquent un par un.")
        phrase3.set("Le premier farfadet, armé d'une spatule, s'avance vers vous.")
        phrase4.set("")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set("Engager le combat")
    elif num==365.2:
        if joueur.est_mort():
            phrase2.set("Le farfadet parvient à vous assener un coup de spatule à l'arrière de la tête.")
            phrase3.set("Vous baslculez en avant, étourdi, et vous tombez la tête la première.")
            phrase4.set("Les autres farfadets vous achèvent.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            monstre.nouveau('FARFADET 2',8,3,["Vous louchez sur la louche de votre adversaire.\nCe mauvais jeu de mots vous destabilise et vous ne voyez pas venir son attaque.","Le farfadet vous attaque avec une louche.\nVous trouvez ça louche... et douloureux."],fuite="Vous vous enfuyez à toutes jambes sous une pluie de fourchettes.")
            phrase2.set("La créature tombe à terre.")
            phrase3.set("Vous pouvez, si vous le souhaîtez, prendre la fuite\nmais il aura l'occasion de vous blesser et vous perderz deux points d'endurance.")
            phrase4.set("Sinon, vous pouvez continuer le combat en vous attaquant,\ncette fois-ci, au deuxième farfadet.")
            bouton4.grid_remove()
            bouton4.grid_forget()
            bouton1.grid()
            bouton2.grid()
            bt1.set("Combattre")
            bt2.set("Fuir")
    elif num==365.4:
        if joueur.est_mort():
            phrase2.set("Le farfadet abat sa louche de toutes ses forces.")
            phrase3.set("Vous tombez à terre, hébété.")
            phrase4.set("Les autres farfadets vous achèvent.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            bt4.set("Quitter le jeu")
        else:
            monstre.nouveau('FARFADET 3',8,5,["Les couteaux de cuisine volent de tous les côtés.","Le farfadet enfonce son couteau dans votre bras."],fuite="Vous vous enfuyez à toutes jambes sous une pluie de fourchettes.")
            phrase2.set("")
            phrase3.set("Le troisième farfadet s'approche armé d'un couteau de cuisine, l'air menaçant.")
            phrase4.set("")
            bt1.set("Poursuivre le combat")
            bt2.set("Prendre la fuite")
    elif num==365.6:
        if joueur.est_mort():
            phrase2.set("Le farfadet vous enfonce son couteau dans le ventre.")
            phrase3.set("")
            phrase4.set("Oups, vous n'êtes plus en vie.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            bt4.set("Quitter le jeu")
        else:
            monstre.nouveau('FARFADET 4',8,4,["Le farfadet fait tourner son rouleau à patisserie, l'air menaçant.","Le farfadet vous malmène comme une pâte à pain."],fuite="Vous vous enfuyez à toutes jambes sous une pluie de fourchettes.")
            phrase2.set("")
            phrase3.set("Place au quatrième farfadet !")
            phrase4.set("")
            bt1.set("Combattre")
            bt2.set("Fuir")
    elif num==365.8:
        if joueur.est_mort():
            phrase2.set("Vous ne savez pas bien comment, mais ce rouleau à patisserie a eu raison de vous.")
            phrase3.set("Quelle défaite cuisante!")
            phrase4.set("")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            bt4.set("Quitter le jeu")
        else:
            monstre.nouveau('FARFADET 5',9,6,["Le farfadet vous lance des os de rats à la figure.","Le farfadet vous lance des petites cuillères."],fuite="Vous vous enfuyez à toutes jambes sous une pluie de fourchettes.")
            phrase2.set("Plus qu'un farfadet !")
            phrase3.set("Vous approchez du but, n'abandonnez pas !")
            phrase4.set("")
    elif num==183:
        if joueur.est_mort():
            phrase2.set("")
            phrase3.set("Le farfadet vous achève à coups de marmite.")
            phrase4.set("")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bouton1.grid_remove()
            bouton1.grid_forget()
            bouton2.grid_remove()
            bouton2.grid_forget()
            bouton4.grid()
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("Je parvins avec difficulté à les tuer. ")
            phrase1.set("n°183")
            phrase2.set("Vous êtes fier de votre victoire !\nVous prenez 1 point d'habilité et 5 points d'endurance.")
            phrase3.set("Vous fouillez ensuite la pièce à la recherche de quelque chose d'interressant\nmais vous ne trouvez dans les placards que de la nourriture moisie et des assiettes ébréchées.")
            phrase4.set("Soudain, vous apercevez une malette de cuir dans un coin de la pièce sous un dressoir.")
            joueur.aug_hab(1)
            joueur.aug_end(5)
            bt1.set("Ouvrir la malette")
            bt2.set("La laisser et partir")
    elif num==266:
        journal.ecrit("Je fouillai la pièce et trouvai une malette en cuir qui contenait un magnifique arc muni d'une flèche d'argent. Je repartis avec l'arme. ")
        var_habilite.set(joueur.get_hab())
        var_endurance.set(joueur.get_end())
        phrase1.set("n°266")
        phrase2.set("En ouvrant la malette, vous découvrez\nun arc magnifique accompagnée d'une flèche d'argent.")
        phrase3.set("Sur le couvercle de la malette,vous pouvez lire :")
        phrase4.set("'Celui qui donne le sommeil à ceux qui ne peuvent dormir...'")
        label_phrase4.config(font=("Pristina"))
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==266.2:
        label_phrase4.config(font=("TkDefaultFont"))
        phrase2.set("Vous ignorez ce que cela signifie mais emportez l'arc avec vous.")
        phrase3.set("")
        label_consolas.grid(row=5,column=3,columnspan=6)
        phrase_consolas.set("[l'objet 'Arc et flèche d'argent' a été ajouté à votre inventaire]") 
        joueur.add_inv("Arc et flèche d'argent"," : 'Celui qui donne le sommeil à ceux qui ne peuvent dormir...'")
        phrase4.set("Vous gagnez 1 point de chance pour cette découverte.")
        joueur.aug_cha(1)
    elif num==266.3:
        journal.ecrit("Je retournai à la bifurcation où je pris la direcion du nord. ")
        label_consolas.grid_forget()
        var_chance.set(joueur.get_cha())
        phrase1.set("n°237")
        phrase2.set("Vous retournez dans le couloir.")
        phrase3.set("De retour à la bifurcation,")
        phrase4.set("vous tournez à droite en direction du nord.")
    elif num==183.2:
        journal.ecrit("Je retournai à la bifurcation où je pris la direcion du nord. ")
        var_habilite.set(joueur.get_hab())
        var_endurance.set(joueur.get_end())
        phrase1.set("n°237")
        phrase2.set("Vous abandonnez la malette et retournez dans le couloir.")
        phrase3.set("De retour à la bifurcation,")
        phrase4.set("vous tournez à droite en direction du nord.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==237:
        journal.ecrit("Je retournai à la bifurcation où je pris la direcion du nord. ")
        phrase1.set("n°237")
        phrase2.set("Vous courez le long du passage et vous arrivez")
        phrase3.set("de nouveau à la bifurcation.")
        phrase4.set("Vous prenez la direction du nord.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
        
    elif num==285:
        phrase1.set("n°285")
        phrase2.set("En progressant vers le nord dans ce nouveau couloir,\nvous passez devant une porte sur votre droite.")
        phrase3.set("Vous entendez un homme appeler à l'aide.")
        phrase4.set("Ferez-vous preuve d'altruisme en vous ruant à son secours,\nou d'une cruelle indifférence en poursuivant votre chemin?")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bt1.set("Entrer")
        bt2.set("Avancer")
        
        
        ##########pièce 5
        progression.actualiser()
       
        
    
    elif num==36:
        journal.ecrit("J'entrai et découvris un viel homme qui se jeta sur moi")
        phrase1.set("n°36")
        phrase2.set("Vous enfoncez la porte qui s'ouvre à la volée.\nUne puanteur immonde vous monte immédiatement aux narines.")
        phrase3.set("Vous vous apercevez avec dégout que le plancher est recouvert\nde vase, d'os et de végétaux en décomposition.")
        phrase4.set("Un viel homme aux cheveux ébouriffés, vêtu de haillons,\nse rue sur vous en hurlant, un vieux pied de chaise à la main.")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bt1.set("Crier pour tenter de le calmer")
        bt2.set("Tirer votre épée et l'attaquer")
    elif num==263:
        pieces_visitees.append("vieux")
        phrase1.set("n°263")
        phrase2.set("Vous prenez une grande inspiration avant de crier :\n'Te voilà libre, vieillard!'.")
        phrase3.set("Il cesse aussitôt ses hurlements et s'effondre sur le sol en pleurant à gros sanglots.")
        phrase4.set("Puis, petit à petit, il se reprend et vous remercie chaleureusement.\nVous bavardez avec lui et il commence à vous raconter son histoire.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==263.2:
        phrase2.set("Il y a de nombreuses années, il était, tout comme vous,\nparti à l'aventure à la recherche du trésor du sorcier.")
        phrase3.set("Les farfadets l'avaient alors capturé et jeté dans cette cellule.\nIl était devenu une sorte d'humain de compagnie et n'avait plus vu la lumière du jour depuis.")
        phrase4.set("Vous lui demandez s'il souhaite vous accompagner dans votre quête,\nmais il n'a qu'un seul désir : revoir le monde extérieur.")
    elif num==263.3:
        phrase2.set("Vous lui demandez alors s'il a appris des choses qui pourraient\nvous aider dans votre périple durant sa captivité.")
        phrase3.set("Il vous recommande de vous montrer respectueux avec le passeur et de tirer le levier de droite\nqui se trouve dans le mur un peu plus loin pour ouvrir la grille de fer.")
        phrase4.set("Il sait aussi que les clés du hangar à bateaux sont gardées par un homme et son chien.")
    elif num==263.4:
        journal.ecrit(" en poussant un cri de joie. Les larmes aux yeux, il me raconta son émouvante histoire : il était, tout comme moi, parti à la recherche du trésor du sorcier de la montagne de feu. Hélas, il fut capturé par des farfadets qui le firent prisonnier. Il me donna de judicieux conseils pour la suite de mon aventure puis nous nous quittâmes, lui regagnant la sortie et moi continuant mon périple. ")
        phrase2.set("Vous vous serrrez la main, et quittez tous deux la pièce, prenant chacun un chemin différent.")
        phrase3.set("Vous vous félicitez de cette heureuse rencontre. Vous gagnez un point de chance.")
        joueur.aug_cha(1)
        phrase4.set("De retour dans le couloir, vous continuez vers le nord.")
    elif num==353:
        journal.ecrit(". Je le tuai. ")
        phrase1.set("n°353")
        phrase2.set("Alors que le viellard bondit sur vous, vous lui passer votre épée au travers de la poitrine.\nMais vous réalisez aussitôt que le vieillard ne cherchait pas à vous attaquer.")
        phrase3.set("Son excitation était simplement due au soulagement qu'il éprouvait d'être enfin libéré.\nVous ne pouvez plus maintenant lui poser de questions sur les périls qui vous attendent.")
        phrase4.set("Vous retournez dans le couloir en vous maudissant d'avoir agi ainsi.\nVous continuez vers le nord.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
    elif num==314:
        phrase1.set("n°314")
        var_chance.set(joueur.get_cha())
        var_endurance.set(joueur.get_end())
        phrase2.set("Un peu plus loin, vous découvrez une autre porte,")
        phrase3.set("toujours dans le mur est du passage")
        phrase4.set("Desirez-vous l'ouvrir?")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bt1.set("Ouvrir la porte")
        bt2.set("Poursuivre")
        
        
        ##########pièce 6
        progression.actualiser()
        
       
    elif num==223:
        
        phrase1.set("n°223")
        phrase2.set("")
        phrase3.set("La porte est solidement fermée.")
        phrase4.set("")
        bt1.set("Essayer de la\nforcer")
        bt2.set("Continuer dans\nle couloir")
    
    
    elif num==155:
        phrase1.set("n°155")
        phrase2.set("Vous parvenez à casser le panneau de bois et à entrer.")
        phrase3.set("Une torche fixée à l'un des murs éclaire une petite salle d'armes remplie d'épées,\nde boucliers, de poignards et d'autres armes en tout genre...")
        phrase4.set("Alors que vous explorer la pièce, un bouclier rond sur lequel est gravé un\ncroissant de lune attire votre regard.")
    
    elif num==155.2:
        journal.ecrit("Dans la pièce, je trouvai un bouclier rond gravé d'un croissant de lune. Il me permettra à coup sûr de mieux me défendre face aux ennemis que je croiserais dans la suite de mon aventure. ")
        joueur.retirer_inv("bouclier")
        joueur.add_inv("bouclier de lune"," : 17% de chance de ne perdre qu'un point à chaque dégât pris.")
        phrase2.set("Ce bouclier de haute facture vous aidera à détourner les attaques de vos ennemis.\nVous décidez d'abandonner votre ancien bouclier et le remplacez par votre trouvaille.")
        phrase3.set("")
        label_consolas.grid(row=5,column=3,columnspan=6)
        phrase_consolas.set("[l'objet 'bouclier' a été retiré de votre inventaire]")
        label_phrase4.config(font=("consolas",8))
        phrase4.set("[l'objet 'bouclier de lune' a été ajouté à votre inventaire]")
        
    elif num==300:
        
        label_consolas.grid_forget()
        label_phrase4.config(font=("TkDefaultFont"))
        var_endurance.set(joueur.get_end())
        phrase1.set("n°300")
        phrase2.set("Vous arrivez à une autre porte sur votre droite.")
        phrase3.set("Alors que vous vous approchez, un hurlement déchire le silence :")
        phrase4.set("Une séance de torture a lieu en ce moment même.")
        bouton4.grid_remove()
        bouton4.grid_forget()
        bouton1.grid()
        bouton2.grid()
        bt1.set("Se ruer sur la porte")
        bt2.set("Poursuivre votre chemin")
        
        
        ##########pièce 7
        progression.actualiser()
        
        
    elif num==102:
        journal.ecrit("\n\n        Soudain, un hurlement déchira le silence. Je courai dans sa direction. Les cris provenait d'une salle de torture où deux lutins suppliciaient un nain. ")
        phrase1.set("n°102")
        phrase2.set("La porte s'ouvre sur une pièce de torture. Au centre de la pièce, deux petites créatures\nbossues exercent leur ignoble besogne sur un nain attaché\npar les poignets à un crochet fixé au plafond.")
        phrase3.set(" Le nain pousse un dernier cri puis se tait, les yeux fermés.")
        phrase4.set("Ses géôliers émettent des exclamations de dépit et se tournent vers vous avec colère,\ncomme si vous étiez responsable de son évanouissement.")
        bouton1.grid(row=8,column=3,columnspan=2)
        bouton2.grid(row=8,column=5,columnspan=2)
        bouton3.grid(row=8,column=7,columnspan=2)
        bt1.set("Refermer la porte et\npoursuivre votre chemin")
        bt2.set("Tirer votre épée et\ncombattre les deux créatures")
        bt3.set("Blesser le nain pour donner\nle change aux tortionnaires")
    elif num==19:
        journal.ecrit("Je dégainai mon épée et me rua à la rescousse du nain, bien décidé à faire payer ces tortionnaires. ")
        phrase1.set("n°19")
        phrase2.set("Ces créatures malfaisantes sont des lutins.")
        phrase3.set("Ils vous attaquent un par un.")
        phrase4.set("")
        if joueur.possede("bouclier de lune"):
            monstre.nouveau('LUTIN 1',5,5,["Le lutin vous attaque.","Flûte! Le lutin lutte et ne se loupe pas!"],particularite="bouclier de lune")
        else:
            monstre.nouveau('LUTIN 1',5,5,["Le lutin vous attaque.","Flûte! Le lutin lutte et ne se loupe pas!"])
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton3.grid_forget()
        bouton4.grid()
        bt4.set("Engager le combat")
    elif num==19.3:
        if joueur.est_mort():
            phrase2.set("Le lutin vous tue.")
            phrase3.set("")
            bt4.set("Quitter le jeu")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
        else :
            phrase2.set("")
            phrase3.set("Le deuxième lutin est déjà sur vous!")
            monstre.nouveau('LUTIN 2',5,6,["Le lutin vous attaque.","Flûte! Le lutin lutte et ne se loupe pas!"])
    elif num==317:
        if joueur.est_mort():
            phrase2.set("Le lutin vous tue.")
            phrase3.set("")
            bt4.set("Quitter le jeu")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
        else :
            journal.ecrit("Malheureusement, le nain était déjà mort à mon arrivée, je ne pus rien faire pour lui. Je fouillais les poches des lutins, dans l'une d'elles, je trouvai un morceau de fromage. Je quittai ensuite la pièce. ")
            phrase1.set("n°317")
            phrase2.set("Vous coupez la corde à laquelle est pendu le nain.\nComme vous le pensiez, il est bel et bien mort.")
            phrase3.set("En fouillant les poches des lutins, vous trouvez un morceau de fromage à l'odeur alléchante.")
            phrase4.set("")
            phrase_consolas.set("[l'objet 'morceau de fromage' a été ajouté à votre inventaire]")
            label_consolas.grid(row=6,column=3,columnspan=6)
            joueur.add_inv("morceau de fromage"," : son odeur alléchante vous donne l'eau à la bouche.")
            bt4.set(" suite ")
    elif num==68:
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton3.grid_forget()
        bouton4.grid()
        phrase1.set("n°68")
        phrase2.set("Nous ne vous demanderons pas quelle idée saugrenue vous est passée par la tête.")
        phrase3.set("Nous esperons simplement pour votre santé mentale et la sécurité de votre entourage \nque vous aviez remarqué que le nain était mort et qu'il s'agissait là d'une ruse.")
        phrase4.set("Si c'en était une, elle a fonctionné puisque les lutins,\naprès avoir échangé un regard stupéfait, arborent un grand sourire et partent chercher\nun autre nain pour que vous puissiez continuer à vous amuser tous les trois.")
        bt4.set(" suite ")
    elif num==68.2:
        journal.ecrit("Je blessai le nain d'un coup d'épée pour donner le change aux tortionaires. Les lutins sortirent et je pus m'échapper sans dommage. Le nain, quant à lui, était déjà mort à mon arrivée. ")
        phrase2.set("Vous ne trouvez rien d'intéressant dans la pièce, sauf, bien sûr, si les instruments\nde torture constituent pour vous une source d'amusement, auquel cas,")
        phrase3.set("NOUS NE VOUS AUTORISONS PAS A RECUPERER UN DE SES OBJETS")
        phrase4.set("car nous jugeons que de telles pensées ne séent guère à un héros de livre d'aventure.")
    elif num==303:
        journal.ecrit("\n\n        Le couloir débouchait sur une impressionante herse de fer.\nDeux leviers dépassaient du mur. ")
        label_consolas.grid_forget()
        bouton1.grid(row=8,column=3,columnspan=3)
        bouton2.grid(row=8,column=6,columnspan=3)
        bouton3.grid_forget()
        bouton4.grid_remove()
        bouton4.grid_forget()
        phrase1.set("n°303")
        phrase3.set("Vous progressez dans le couloir.\nBientôt, une herse se dresse devant vous.")
        phrase4.set("Deux leviers dépassent du mur sur votre droite.\nLequel ouvre la grille?")
        bt1.set("Tirer le\nlevier gauche")
        bt2.set("Tirer le\nlevier droit")
        
        
        ##########pièce 8
        progression.actualiser()
        
        
    elif num==243:
        phrase1.set("n°243")
        if "vieux" in pieces_visitees:
            phrase2.set("Mais enfin, vous n'avez pas écouté le viel homme?\nCa vallait bien la peine de le sauver, tiens!")
        else:
            phrase2.set("Râté! C'est le mauvais levier!")
        phrase3.set("La poignée est en fait une lame recouverte de cire.\nVous vous coupez en la saisissant.")
        phrase4.set("Lancez un dé pour connaitre la gravité de votre blessure.\nSi le chiffre obtenu est impair, la coupure est profonde.\nS'il est pair, le mal est bénin, mais vous êtes tout de même blessé.")
        bouton1.grid_remove()
        bouton1.grid_forget()
        bouton2.grid_remove()
        bouton2.grid_forget()
        bouton4.grid()
    elif num==243.2:
        phrase2.set("")
        phrase3.set("")
        phrase4.set("")
        bouton4.grid(row=4,column=3,columnspan=6)
        bt4.set("Lancer un dé")
    elif num==243.3:
        label_consolas.grid(row=5,column=3,columnspan=6)
        label_phrase4.config(font=("consolas",8))
        des=randint(1,6)
        phrase2.set("Vous obtenez "+str(des)+".")
        if des%2==0:
            joueur.aug_hab(-1)
            joueur.blesser(2)
            phrase_consolas.set("[Vous perdez 1 point(s) d'habilité]")
            phrase4.set("[Vous perdez 2 point(s) d'endurance']")
        else:
            joueur.aug_hab(-3)
            joueur.blesser(1)
            phrase_consolas.set("[Vous perdez 3 point(s) d'habilité]")
            phrase4.set("[Vous perdez 1 point(s) d'endurance']")
        bouton4.grid(row=8,column=3,columnspan=6)
        bt4.set(" suite ")
    elif num==243.4:
        var_habilite.set(joueur.get_hab())
        var_endurance.set(joueur.get_end())
        
        label_phrase4.config(font=("TkDefaultFont"))
        label_consolas.grid_forget()
        phrase4.set("")
        if joueur.est_mort():
            phrase2.set("Bon, je veux pas dire, mais mourir en se coupant la main,")
            phrase3.set("ça craint quand même.")
            bouton4.config(command=lambda:[graphique(),fenetre_smf.destroy()])
            bt4.set("Quitter le jeu")
        else:
            journal.ecrit("Je tirai le levier gauche qui était malheureusement un leurre et me blessai sur une lame recouverte de cire. ")
            phrase2.set("")
            phrase3.set("Vous n'avez plus le choix désormais :")
            bt4.set("Tirer le\nlevier droit")
        
    elif num==128:
        journal.ecrit("Je tirai le levier droit et la grille s'éleva lentement. ")
        phrase1.set("n°128")
        phrase2.set("Vous entendez un grondement et sentez le sol trembler sous vos pieds.")
        phrase3.set("La herse s'élève lentement.")
        phrase4.set("")
        bouton1.grid_forget()
        bouton2.grid_forget()
        bouton4.grid()
        bt4.set(" suite ")
        
        ##########pièce 9
        
        graphique()
    
    elif num==128.2:
        phrase2.set("Félicitation !")
        phrase3.set("Vous avez terminé la première partie du 'Sorcier de la montagne de feu'")
        phrase4.set("écrit par Steve Jackson et Ian Livingstone.")
    elif num==128.3:
        phrase2.set("Pour connaitre la suite du périple de notre héros intrépide,")
        phrase3.set("achetez la version originale papier du 'Sorcier de la montagne de feu !")
        phrase4.set("Munissez-vous de deux dés, d'une gomme et d'un crayon de papier\net partez à l'aventure à la recherche du trésor du sorcier !")
        bt4.set("Je cours acheter le\n'Soricer de la montagne de feu' !")
        bouton4.config(command=fenetre_smf.destroy)
    
    
    




# Les fonctions suivantes sont appelée par les boutons '? '.
# Elles ouvrent des fenêtres d'information
# sur les caractéristiques du joueur (habilité, endurance,
# provisions ...)


def aide_hab():
    fenetre_aide_hab=tk.Tk()
    fenetre_aide_hab.title("aide habilité")
    fenetre_aide_hab.geometry("450x200")
    label_vide_aide_hab=tk.Label(fenetre_aide_hab,text='')
    label_vide_aide_hab.grid(row=0,column=0)
    label_titre_aide_hab=tk.Label(fenetre_aide_hab,text="L'HABILITE",fg='red',font=("Castellar"))
    label_titre_aide_hab.grid(row=1,column=1)
    label_vide2_aide_hab=tk.Label(fenetre_aide_hab,text='')
    label_vide2_aide_hab.grid(row=2,column=0)
    label_aide_hab=tk.Label(fenetre_aide_hab,text="L'habilité représente votre force physique et votre habilité au combat.\nElle vous sera utile lorsque vous vous battrez contre des monstres dans le jeu.\nQue la force soit avec vous !")
    label_aide_hab.grid(row=3,column=1)
    label_vide3_aide_hab=tk.Label(fenetre_aide_hab,text='')
    label_vide3_aide_hab.grid(row=4,column=0)
    quitter_aide_hab=tk.Button(fenetre_aide_hab,text='Retourner au jeu',command=fenetre_aide_hab.destroy)
    quitter_aide_hab.grid(row=5,column=1)
    
def aide_end():
    fenetre_aide_end=tk.Tk()
    fenetre_aide_end.title("aide endurance")
    fenetre_aide_end.geometry("650x200")
    label_vide_aide_end=tk.Label(fenetre_aide_end,text='')
    label_vide_aide_end.grid(row=0,column=0)
    label_titre_aide_end=tk.Label(fenetre_aide_end,text="L'ENDURANCE",fg='red',font=("Castellar"))
    label_titre_aide_end.grid(row=1,column=1)
    label_vide2_aide_end=tk.Label(fenetre_aide_end,text='')
    label_vide2_aide_end.grid(row=2,column=0)
    label_aide_end=tk.Label(fenetre_aide_end,text="L'endurance correspond à votre forme physique et votre résilience.\nVos points d'endurance baisseront si vous essuyez une attaque d'un monstre ou si vous vous blessez durant le jeu.\nAttention! Si vos points d'endurance descendent à zéro, vous perdez la partie!")
    label_aide_end.grid(row=3,column=1)
    label_vide3_aide_end=tk.Label(fenetre_aide_end,text='')
    label_vide3_aide_end.grid(row=4,column=0)
    quitter_aide_end=tk.Button(fenetre_aide_end,text='Retourner au jeu',command=fenetre_aide_end.destroy)
    quitter_aide_end.grid(row=5,column=1)
    
def aide_chance():
    fenetre_aide_chance=tk.Tk()
    fenetre_aide_chance.title("aide chance")
    fenetre_aide_chance.geometry("600x230")
    label_vide_aide_chance=tk.Label(fenetre_aide_chance,text='')
    label_vide_aide_chance.grid(row=0,column=0)
    label_titre_aide_chance=tk.Label(fenetre_aide_chance,text="LA CHANCE",fg='red',font=("Castellar"))
    label_titre_aide_chance.grid(row=1,column=1)
    label_vide2_aide_chance=tk.Label(fenetre_aide_chance,text='')
    label_vide2_aide_chance.grid(row=2,column=0)
    label_aide_chance=tk.Label(fenetre_aide_chance,text="La chance est un bonus qui peut vous aider dans votre aventure.\nPendant un combat ou lorsque cela vous sera proposé, vous pourrez tenter votre chance :\nVous lancez deux dés, si le résultat obtenu est supérieur à vos points de chance, vous êtes malchanceux.\n Si le résultat est inférieur ou égal à vos points de chance, vous êtes chanceux.\n\n/!\ Chaque fois que vous tentez votre chance, vous perdez un point de chance.")
    label_aide_chance.grid(row=3,column=1)
    label_vide3_aide_chance=tk.Label(fenetre_aide_chance,text='')
    label_vide3_aide_chance.grid(row=4,column=0)
    quitter_aide_chance=tk.Button(fenetre_aide_chance,text='Retourner au jeu',command=fenetre_aide_chance.destroy)
    quitter_aide_chance.grid(row=5,column=1)

def aide_or():
    fenetre_aide_or=tk.Tk()
    fenetre_aide_or.title("aide or")
    fenetre_aide_or.geometry("400x200")
    label_vide_aide_or=tk.Label(fenetre_aide_or,text='')
    label_vide_aide_or.grid(row=0,column=0)
    label_titre_aide_or=tk.Label(fenetre_aide_or,text="L'OR",fg='red',font=("Castellar"))
    label_titre_aide_or.grid(row=1,column=1)
    label_vide2_aide_or=tk.Label(fenetre_aide_or,text='')
    label_vide2_aide_or.grid(row=2,column=0)
    label_aide_or=tk.Label(fenetre_aide_or,text="L'or est la monaie utilisée dans la montagne de feu.\nVous trouverez sûrement des pièces d'or sur votre route.\nVous pourrez ensuite les échanger contre des services ou des objets\nà certains pnj présents dans le jeu.")
    label_aide_or.grid(row=3,column=1)
    label_vide3_aide_or=tk.Label(fenetre_aide_or,text='')
    label_vide3_aide_or.grid(row=4,column=0)
    quitter_aide_or=tk.Button(fenetre_aide_or,text='Retourner au jeu',command=fenetre_aide_or.destroy)
    quitter_aide_or.grid(row=5,column=1)

def aide_prov():
    fenetre_aide_prov=tk.Tk()
    fenetre_aide_prov.title("aide provisions")
    fenetre_aide_prov.geometry("400x250")
    label_vide_aide_prov=tk.Label(fenetre_aide_prov,text='')
    label_vide_aide_prov.grid(row=0,column=0)
    label_titre_aide_prov=tk.Label(fenetre_aide_prov,text="LES PROVISIONS",fg='red',font=("Castellar"))
    label_titre_aide_prov.grid(row=1,column=1)
    label_vide2_aide_prov=tk.Label(fenetre_aide_prov,text='')
    label_vide2_aide_prov.grid(row=2,column=0)
    label_aide_prov=tk.Label(fenetre_aide_prov,text="Les provisions que vous avez apportées avec vous vous permettront\nde survivre plus longtemps dans la montagne.\nSi vous trouvez un endroit calme pour vous reposer,\nvous pourrez prendre un ou plusieurs repas.\nChaque repas pris vous rendra 4 points d'endurance.\nBon appétit!")
    label_aide_prov.grid(row=3,column=1)
    label_vide3_aide_prov=tk.Label(fenetre_aide_prov,text='')
    label_vide3_aide_prov.grid(row=4,column=0)
    quitter_aide_prov=tk.Button(fenetre_aide_prov,text='Retourner au jeu',command=fenetre_aide_prov.destroy)
    quitter_aide_prov.grid(row=5,column=1)
    
def aide_potion():
    fenetre_aide_potion=tk.Tk()
    fenetre_aide_potion.title("aide potion")
    
    nom_potion=tk.StringVar(master=fenetre_aide_potion)
    texte_potion=tk.StringVar(master=fenetre_aide_potion)
    if joueur.get_type_potion()=="potion d'adresse":
        nom_potion.set("POTION D'ADRESSE")
        texte_potion.set("Votre potion d'adresse vous rend vos points d'habilité de départ ("+str(joueur.get_hab_dep())+").\nUne potion pleine contient deux mesures.\nVous ne pouvez donc l'utiliser que deux fois durant votre partie.\nPour utiliser votre potion d'adresse, cliquez sur le bouton 'potion'.\n\n/!\ Vous ne pouvez pas utiliser votre potion durant un combat !")
        fenetre_aide_potion.geometry("380x250")
    elif joueur.get_type_potion()=="potion de vigueur":
        nom_potion.set("POTION DE VIGUEUR")
        texte_potion.set("Votre potion de vigeur vous rend vos points d'endurance de départ ("+str(joueur.get_end_dep())+").\nUne potion pleine contient deux mesures.\nVous ne pouvez donc l'utiliser que deux fois durant votre partie.\nPour utiliser votre potion de vigueur, cliquez sur le bouton 'potion'.\n\n/!\ Vous ne pouvez pas utiliser votre potion durant un combat!")
        fenetre_aide_potion.geometry("390x250")
    elif joueur.get_type_potion()=="potion de bonne fortune":
        nom_potion.set("POTION DE BONNE FORTUNE")
        texte_potion.set("Votre potion de bonne fortune vous rend vos points de chance de départ\nauquels elle ajoute 1 ("+str(joueur.get_cha_dep()+1)+").\nUne potion pleine contient deux mesures.\nVous ne pouvez donc l'utiliser que deux fois durant votre partie.\nPour utiliser votre potion de bonne fortune, cliquez sur le bouton 'potion'.\n\n/!\ Vous ne pouvez pas utiliser votre potion durant un combat!")
        fenetre_aide_potion.geometry("410x250")
    else:   
        nom_potion.set('POTION')
        texte_potion.set("Les potions vous rendent vos points d'habilité, d'endurance ou de chance de départ.\nUne potion pleine contient deux mesures.\nVous ne pouvez donc l'utiliser que deux fois durant votre partie.\nPour utiliser votre potion, cliquez sur le bouton 'potion'.")
        fenetre_aide_potion.geometry("480x200")
    
    label_vide_aide_potion=tk.Label(fenetre_aide_potion,text='')
    label_vide_aide_potion.grid(row=0,column=0)
    label_titre_aide_potion=tk.Label(fenetre_aide_potion,textvariable=nom_potion,fg='red',font=("Castellar"))
    label_titre_aide_potion.grid(row=1,column=1)
    label_vide2_aide_potion=tk.Label(fenetre_aide_potion,text='')
    label_vide2_aide_potion.grid(row=2,column=0)
    label_aide_potion=tk.Label(fenetre_aide_potion,textvariable=texte_potion)
    label_aide_potion.grid(row=3,column=1)
    label_vide3_aide_potion=tk.Label(fenetre_aide_potion,text='')
    label_vide3_aide_potion.grid(row=4,column=0)
    quitter_aide_potion=tk.Button(fenetre_aide_potion,text='Retourner au jeu',command=fenetre_aide_potion.destroy)
    quitter_aide_potion.grid(row=5,column=1)

def aide_inv():
    fenetre_aide_inv=tk.Tk()
    fenetre_aide_inv.title("aide inventaire")
    fenetre_aide_inv.geometry("450x200")
    label_vide_aide_inv=tk.Label(fenetre_aide_inv,text='')
    label_vide_aide_inv.grid(row=0,column=0)
    label_titre_aide_inv=tk.Label(fenetre_aide_inv,text="L'INVENTAIRE",fg='red',font=("Castellar"))
    label_titre_aide_inv.grid(row=1,column=1)
    label_vide2_aide_inv=tk.Label(fenetre_aide_inv,text='')
    label_vide2_aide_inv.grid(row=2,column=0)
    label_aide_inv=tk.Label(fenetre_aide_inv,text="Tous les objets que vous trouvez sur votre route sont stockés dans votre inventaire.\nPour voir ce que contient votre inventaire,\ncliquez sur le bouton 'inventaire'.")
    label_aide_inv.grid(row=3,column=1)
    label_vide3_aide_inv=tk.Label(fenetre_aide_inv,text='')
    label_vide3_aide_inv.grid(row=4,column=0)
    quitter_aide_inv=tk.Button(fenetre_aide_inv,text='Retourner au jeu',command=fenetre_aide_inv.destroy)
    quitter_aide_inv.grid(row=5,column=1)
    
def aide_journal():
    fenetre_aide_journal=tk.Tk()
    fenetre_aide_journal.title("aide journal")
    fenetre_aide_journal.geometry("350x200")
    label_vide_aide_journal=tk.Label(fenetre_aide_journal,text='')
    label_vide_aide_journal.grid(row=0,column=0)
    label_titre_aide_journal=tk.Label(fenetre_aide_journal,text="LE JOURNAL DE BORD",fg='red',font=("Castellar"))
    label_titre_aide_journal.grid(row=1,column=1)
    label_vide2_aide_journal=tk.Label(fenetre_aide_journal,text='')
    label_vide2_aide_journal.grid(row=2,column=0)
    label_aide_journal=tk.Label(fenetre_aide_journal,text="Votre aventure est consignée dans le journal de bord.\nPour voir ce que contient votre journal,\ncliquez sur le bouton 'journal'.")
    label_aide_journal.grid(row=3,column=1)
    label_vide3_aide_journal=tk.Label(fenetre_aide_journal,text='')
    label_vide3_aide_journal.grid(row=4,column=0)
    quitter_aide_journal=tk.Button(fenetre_aide_journal,text='Retourner au jeu',command=fenetre_aide_journal.destroy)
    quitter_aide_journal.grid(row=5,column=1)





# Les fonctions inventaire(), utiliser_potion()
# et afficher_journal() sont appelées par les
# boutons 'inventaire', 'potion' et 'journal'


def inventaire():
    """
    Cette fonction ouvre une fenêtre qui afficher
    le contenu de l'inventaire du joueur.
    Elle utilise l'objet joueur de la classe Joueur.
    """
    fenetre_inventaire=tk.Tk()
    fenetre_inventaire.title("inventaire")
    fenetre_inventaire.geometry("600x300")
    contenu_inventaire=tk.StringVar(master=fenetre_inventaire)
    
    label_vide_inventaire=tk.Label(fenetre_inventaire,text="               ")
    label_vide_inventaire.grid(row=0,column=0)
    label_titre_inventaire=tk.Label(fenetre_inventaire,text="INVENTAIRE",fg='red',font=("Castellar"))
    label_titre_inventaire.grid(row=1,column=1)
    label_vide2_inventaire=tk.Label(fenetre_inventaire,text="")
    label_vide2_inventaire.grid(row=2,column=0)
    label_inventaire=tk.Label(fenetre_inventaire,text="Dans votre sac, vous avez :",width=70,justify='left', anchor='w')
    label_inventaire.grid(row=3,column=1)
    label_contenu_inventaire=tk.Label(fenetre_inventaire,textvariable=contenu_inventaire, width=70,justify='left',anchor='w')
    label_contenu_inventaire.grid(row=4,column=1) 
    quitter_inventaire=tk.Button(fenetre_inventaire,text='Retourner au jeu',command=fenetre_inventaire.destroy)
    quitter_inventaire.grid(row=5,column=1)
    
    
    contenu_inventaire.set(joueur.get_inv())


def utiliser_potion():
    fenetre_potion=tk.Tk()
    fenetre_potion.title("potion")
    fenetre_potion.geometry("330x200")
    texte_utiliser_potion=tk.StringVar(master=fenetre_potion)
    if joueur.get_type_potion()=="potion d'adresse":
        texte_utiliser_potion.set("Vos points d'habilité s'élèveront à "+str(joueur.get_hab_dep()))
    elif joueur.get_type_potion()=="potion de vigueur":
        texte_utiliser_potion.set("Vos points d'endurance s'élèveront à "+str(joueur.get_end_dep()))
    elif joueur.get_type_potion()=="potion de bonne fortune":
        texte_utiliser_potion.set("Vos points de chance s'élèveront à "+str(joueur.get_cha_dep()+1))
    label_vide_potion=tk.Label(fenetre_potion,text='   ')
    label_vide_potion.grid(row=0,column=0)
    label_titre_potion=tk.Label(fenetre_potion,text="ETES-VOUS SÛR DE VOULOIR\nBOIRE VOTRE POTION ?",fg='red',font=("Castellar"))
    label_titre_potion.grid(row=1,column=1,columnspan=2)
    label_vide2_potion=tk.Label(fenetre_potion,text='')
    label_vide2_potion.grid(row=2,column=0)
    label_potion=tk.Label(fenetre_potion,textvariable=texte_utiliser_potion)
    label_potion.grid(row=3,column=1,columnspan=2)
    label_vide3_potion=tk.Label(fenetre_potion,text='')
    label_vide3_potion.grid(row=4,column=0)
    non_potion=tk.Button(fenetre_potion,text='non',command=fenetre_potion.destroy)
    non_potion.grid(row=5,column=2)
    oui_potion=tk.Button(fenetre_potion,text='oui',command=lambda:[joueur.boire_potion(),potion_bue(),fenetre_potion.destroy()])
    oui_potion.grid(row=5,column=1)

def potion_bue(): 
    var_habilite.set(joueur.get_hab())
    var_endurance.set(joueur.get_end())
    var_chance.set(joueur.get_cha())
    var_potion.set(joueur.get_potion())
    
    if joueur.get_potion()<=0:
        bouton_potion.config(state=tk.DISABLED, relief='sunken')
        


def affiche_journal():
    """
    Cette fonction ouvre une fenêtre qui afficher
    le contenu du journal du joueur.
    Elle utilise l'objet journal de la classe Journal.
    """
    
    global page
    pages=journal.afficher()
    page=0

    def page_precedente():
        global page
        page-=1
        if bouton2_journal['state']==tk.DISABLED:
            bouton2_journal.config(state=tk.NORMAL,relief='raised')
        if page==0:
            bouton1_journal.config(state=tk.DISABLED,relief='sunken')
        contenu_journal.set(pages[page])
    
    def page_suivante():
        global page
        page+=1
        if bouton1_journal['state']==tk.DISABLED:
            bouton1_journal.config(state=tk.NORMAL,relief='raised')
        if page==len(pages)-1:
            bouton2_journal.config(state=tk.DISABLED,relief='sunken')
        contenu_journal.set(pages[page])

    fenetre_journal=tk.Tk()
    fenetre_journal.title("journal")
    fenetre_journal.geometry("460x510")
    contenu_journal=tk.StringVar(master=fenetre_journal)
    
    label_vide_journal=tk.Label(fenetre_journal,text="     ")
    label_vide_journal.grid(row=0,column=0)
    label_titre_journal=tk.Label(fenetre_journal,text="JOURNAL DE BORD",fg='red',font=("Castellar"))
    label_titre_journal.grid(row=1,column=1,columnspan=2)
    label_vide2_journal=tk.Label(fenetre_journal,text="")
    label_vide2_journal.grid(row=2,column=0)
    label_contenu_journal=tk.Label(fenetre_journal,textvariable=contenu_journal,width=50,justify='left',anchor='w',font=('Pristina',13))
    label_contenu_journal.grid(row=3,column=1,columnspan=2) 
    bouton1_journal=tk.Button(fenetre_journal,text="page précédente",command=page_precedente,state=tk.DISABLED,relief='sunken')
    bouton1_journal.grid(row=4,column=1)
    bouton2_journal=tk.Button(fenetre_journal,text="page suivante",command=page_suivante)
    bouton2_journal.grid(row=4,column=2)
    quitter_journal=tk.Button(fenetre_journal,text='Fermer le journal',command=fenetre_journal.destroy)
    quitter_journal.grid(row=5,column=1,columnspan=2,pady=10)
    
    
    if len(pages)==1:
        bouton2_journal.config(state=tk.DISABLED,relief='sunken')
    
    contenu_journal.set(pages[0])
    
    



# Les fonctions repas() et combat()
# sont appelées dans la fonction choix()
# lorsque le joueur a l'occasion 
# de combattre un monstre ou de prendre un repas.
    
    
def repas():
    """
    Cette fonction est appelée dans la fonction choix().
    Elle ouvre une fenêtre qui permet au joueur de 
    prendre un repas.
    Elle utilise l'objet joueur de la classe Joueur.
    """
    fenetre_repas=tk.Tk()
    fenetre_repas.title("Prendre un repas")
    fenetre_repas.geometry("450x300")
    repas_endurance=tk.IntVar(master=fenetre_repas)
    repas_provision=tk.IntVar(master=fenetre_repas)
    repas_endurance.set(joueur.get_end())
    repas_provision.set(joueur.get_prov())
    phrase_repas=tk.StringVar(master=fenetre_repas)
    phrase_consolas_repas=tk.StringVar(master=fenetre_repas)
    question_repas=tk.StringVar(master=fenetre_repas)
    question_repas.set("Voulez-vous prendre un repas?")
    
    def repas_confirm():
        if joueur.get_end()+4>joueur.get_end_dep():
            fenetre_repas_info=tk.Tk()
            fenetre_repas_info.title("information")
            fenetre_repas_info.geometry("300x200")
            
            label_vide_repas_info=tk.Label(fenetre_repas_info,text='   ')
            label_vide_repas_info.grid(row=0,column=0)
            label_titre_repas_info=tk.Label(fenetre_repas_info,text="ETES-VOUS SÛR DE VOULOIR\nPRENDRE UN REPAS ?",fg='red',font=("Castellar"))
            label_titre_repas_info.grid(row=1,column=1,columnspan=2)
            label_vide2_repas_info=tk.Label(fenetre_repas_info,text='')
            label_vide2_repas_info.grid(row=2,column=0)
            label_repas_info=tk.Label(fenetre_repas_info,text="Vous ne récupérerez que "+str(joueur.get_end_dep()-joueur.get_end())+" point(s) d'endurance.")
            label_repas_info.grid(row=3,column=1,columnspan=2)
            label_vide3_repas_info=tk.Label(fenetre_repas_info,text='')
            label_vide3_repas_info.grid(row=4,column=0)
            non_repas_info=tk.Button(fenetre_repas_info,text='non',command=fenetre_repas_info.destroy)
            non_repas_info.grid(row=5,column=2)
            oui_repas_info=tk.Button(fenetre_repas_info,text='oui',command=lambda:[repas_oui(),fenetre_repas_info.destroy()])
            oui_repas_info.grid(row=5,column=1)
        else:
            repas_oui()
    def repas_oui():
        joueur.mange()
        repas_endurance.set(joueur.get_end())
        repas_provision.set(joueur.get_prov())
        
        phrase_repas.set(["Manger vous redonne des forces.","Vous enfournez un sandwich.","Vous croquez dans un petit pain.","Miam, miam! Quel délice!"][randint(0,3)])
        fin_repas()
    
    def fin_repas():
        if joueur.get_prov()<=0 or joueur.get_end() == joueur.get_end_dep():
            if joueur.get_prov()<=0:
                question_repas.set("Vos provisions sont vides.")
            else:
                question_repas.set("Vous êtes au top de votre forme!")
            bouton_oui_repas.grid_forget()
            bouton_non_repas.grid(row=10,column=1,columnspan=4)
            bouton_non_repas.config(text='Retourner au jeu')
        
    label_vide_repas=tk.Label(fenetre_repas,text='')
    label_vide_repas.grid(row=0,column=0)
    label_titre_repas=tk.Label(fenetre_repas,text="PRENDRE UN REPAS",fg='red',font=("Castellar"))
    label_titre_repas.grid(row=1,column=1,columnspan=3)
    label_vide2_repas=tk.Label(fenetre_repas,text='',width=60)
    label_vide2_repas.grid(row=2,column=1,columnspan=3)
    label_repas_endurance=tk.Label(fenetre_repas,text="Endurance :")
    label_repas_endurance.grid(row=3,column=1)
    label_repas_endurance_value=tk.Label(fenetre_repas,textvariable=repas_endurance)
    label_repas_endurance_value.grid(row=3,column=2)
    label_repas_provision=tk.Label(fenetre_repas,text="Provisions :")
    label_repas_provision.grid(row=4,column=1)
    label_vide3_repas=tk.Label(fenetre_repas,text="",width=29)
    label_vide3_repas.grid(row=3,column=3,columnspan=3)
    label_repas_provision_value=tk.Label(fenetre_repas,textvariable=repas_provision)
    label_repas_provision_value.grid(row=4,column=2)
    label_vide4_repas=tk.Label(fenetre_repas,text='')
    label_vide4_repas.grid(row=5,column=0)
    
    
    label_phrase_repas=tk.Label(fenetre_repas,textvariable=phrase_repas,fg='red')
    label_phrase_repas.grid(row=6,column=1,columnspan=4)
    label_phrase_consolas_repas=tk.Label(fenetre_repas,textvariable=phrase_consolas_repas,font=("consolas",8))
    label_phrase_consolas_repas.grid(row=7,column=1,columnspan=4)
    label_question_repas=tk.Label(fenetre_repas,textvariable=question_repas)
    label_question_repas.grid(row=8,column=1,columnspan=4)
    label_vide6_repas=tk.Label(fenetre_repas,text='')
    label_vide6_repas.grid(row=9,column=0)
    
    bouton_oui_repas=tk.Button(fenetre_repas,text=' Oui ',command=repas_confirm)
    bouton_oui_repas.grid(row=10,column=1,columnspan=2)
    bouton_non_repas=tk.Button(fenetre_repas,text=' Non ',command=lambda:[choix("repas"),fenetre_repas.destroy()])
    bouton_non_repas.grid(row=10,column=3,columnspan=2)
    fin_repas()
    

def combat():
    """
    Cette fonction est appelée dans la fonction choix().
    Elle ouvre une fenêtre qui permet au joueur de 
    mener un combat avec un monstre.
    Elle utilise l'objet joueur de la classe Joueur
    et l'objet monstre de la classe Monstre
    """
    if monstre.get_part()!=None:
        fenetre_combat_info=tk.Tk()
        fenetre_combat_info.title("information")
        information_combat_info=tk.StringVar(master=fenetre_combat_info)
        information2_combat_info=tk.StringVar(master=fenetre_combat_info)
        
        if monstre.get_part()=="premier monstre":
            fenetre_combat_info.geometry("950x430")
            information_combat_info.set("""Vous combattez un monstre pour la première fois. Voici donc quelques explications sur les combats dans le jeu.\n\nLors d'un combat, deux variables importantes sont à prendre en compte :
- l'habilité, votre force brute et votre aptitude au combat\n- l'endurance qui représente vos points de vie                   \n
Les votres et celles de votre adversaire sont affichés en dessous de vos noms respectifs.\n\nA chaque tour, vous devez lancer les dés pour vous et pour le monstre.\nOn ajoute ensuite au résultat les points d'habilité pour donner la puissance d'attaque.
Si votre puissance d'attaque est supérieure à celle de votre adversaire, il perd deux points d'endurance.\nDans le cas contraire, c'est vous qui perdez deux points d'endurance.\nPersonne ne perd de points si les puissances d'attaque sont égales.\n
Vous aurez ensuite la possibilité de tenter votre chance selon les règles du jeu pour aggraver la blessure du monstre ou soulager la blessure qui vous a été faite :
Vous lancez deux dés, si le résultat est inférieur à vos points de chance, vous êtes chanceux, à l'inverse, si les résultat est supérieur, vous êtes malchanceux.
Mais attention, si vous êtes malchanceux, le monstre n'aura persque rien ou votre blessure s'aggravera!\nEt n'oubliez pas qu'à chaque fois que vous tentez votre chance, vous perdez un point de chance et risquez d'être de plus en plus malchanceux!.""")
            information2_combat_info.set("Le combat se poursuit jusqu'à ce que les points d'endurance de l'un de vous deux soient à zéro.\nSi vous trouvez le combat trop long, vous pouvez cliquer sur 'combat automatique' pour avoir directement le résultat du combat.\n")
        
        elif monstre.get_part()=="ivresse":
            fenetre_combat_info.geometry("500x200")
            information_combat_info.set("Votre adveraire est ivre.")
            information2_combat_info.set("Votre puissance d'attaque est augmentée d'un point à chaque attaque.\n")
        
        elif monstre.get_part()=="bouclier de lune" :
            fenetre_combat_info.geometry("500x200")
            information_combat_info.set("Vous utilisez votre bouclier de lune pour la première fois.\nIl vous offre un bonus de défense :")
            information2_combat_info.set("Chaque fois qu'un monstre vous inflige des dégâts, vous avez une chance sur six\nd'esquiver l'attaque et de ne perdre qu'un point au lieu de deux.\n")
        
        label_vide_combat_info=tk.Label(fenetre_combat_info,text="               ")
        label_vide_combat_info.grid(row=0,column=0)
        label_titre_combat_info=tk.Label(fenetre_combat_info,text="INFORMATION",fg='red',font=("Castellar"))
        label_titre_combat_info.grid(row=1,column=1)
        label_vide2_combat_info=tk.Label(fenetre_combat_info,text="")
        label_vide2_combat_info.grid(row=2,column=0)
        label_combat_info=tk.Label(fenetre_combat_info,textvariable=information_combat_info,)
        label_combat_info.grid(row=3,column=1)
        label2_combat_info=tk.Label(fenetre_combat_info,textvariable=information2_combat_info,)
        label2_combat_info.grid(row=4,column=1)
        quitter_combat_info=tk.Button(fenetre_combat_info,text='  OK  ',command=fenetre_combat_info.destroy)
        quitter_combat_info.grid(row=5,column=1)
    
    
    def combat_auto():
        while not joueur.est_mort() and not monstre.est_mort():
            joueur.random_power()
            monstre.random_power()
            
            if joueur > monstre : 
                monstre.blesser(2)
                
            elif joueur < monstre :
                if joueur.possede("bouclier de lune") and randint(1,6)==6:
                    joueur.blesser(1)
                else : 
                    joueur.blesser(2)
                    
        suite_combat.set(" suite ")
        fct_suite_combat()
    
    def fct_des_joueur():
        
        power_joueur.set(joueur.random_power())
        bouton_des_joueur.config(state=tk.DISABLED,relief='sunken')
        
        if power_joueur.get()!="0" and power_monstre.get()!="0":
            fct_compar_power()
    
    def fct_des_monstre():
        
        power_monstre.set(monstre.random_power())
        bouton_des_monstre.config(state=tk.DISABLED,relief='sunken')
        
        if power_joueur.get()!="0" and power_monstre.get()!="0":
            fct_compar_power()
        
    def fct_compar_power():
        if joueur > monstre: #la puissance d'attaque du joueur est supérieure à celle du monstre
            phrase_attaque.set(joueur.attaque())
            pt_perdus.set("['"+monstre.get_nom()+"' perd 2 points d'endurance]")
            monstre.blesser(2)
            bouton_tentez_votre_chance.grid()
            
        elif joueur < monstre:
            if joueur.possede("bouclier de lune") and randint(1,6)==6:
                joueur.blesser(1)
                phrase_attaque.set(monstre.attaque()+"\nVotre bouclier de lune vous permet de dévier l'attaque.")
                pt_perdus.set("[Vous perdez 1 point d'endurance]")
            else:
                phrase_attaque.set(monstre.attaque())
                pt_perdus.set("[Vous perdez 2 points d'endurance]")
                joueur.blesser(2)
            bouton_tentez_votre_chance.grid()
        else :
            phrase_attaque.set("Vous esquivez l'attaque. Vous êtes indemne... mais votre adversaire aussi!")
        suite_combat.set(" suite ")
        bouton_suite_combat.config(command=fct_suite_combat)
        
    def fct_chance_combat():
        des=randint(1,6)+randint(1,6)
        phrase_attaque.set("Vous obtenez "+str(des)+"!")
        if joueur.est_chanceux(des): #chanceux
            if joueur > monstre: #monstre blessé
                pt_perdus.set("['"+monstre.get_nom()+"' perd 4 points d'endurance]")
                monstre.blesser(2)
            else: #joueur blessé
                if pt_perdus.get()=="[Vous perdez 2 points d'endurance]":
                    pt_perdus.set("[Vous perdez 1 point d'endurance]")
                else:
                    pt_perdus.set("[Vous perdez 0 point d'endurance]")
                joueur.aug_end(1)
        else : #malchanceux
            if joueur > monstre:
                pt_perdus.set("['"+monstre.get_nom()+"' perd 1 point d'endurance]")
                monstre.blesser(-1)
            else:
                if pt_perdus.get()=="[Vous perdez 2 points d'endurance]":
                    pt_perdus.set("[Vous perdez 3 points d'endurance]")
                else:
                    pt_perdus.set("[Vous perdez 2 points d'endurance]")
                joueur.blesser(1)
        joueur.aug_cha(-1)
        bouton_tentez_votre_chance.config(state=tk.DISABLED,relief="sunken",text="Tentez votre chance ("+str(joueur.get_cha())+")")

    def fct_suite_combat():
        endurance_joueur.set(joueur.get_end())
        endurance_monstre.set(monstre.get_end())
        power_joueur.set("0")
        power_monstre.set("0")
        if joueur.get_cha()>0:
            bouton_tentez_votre_chance.config(state=tk.NORMAL,relief="raised") 
        
        if joueur.est_mort():
            bouton_des_monstre.grid_forget()
            bouton_des_joueur.grid_forget()
            bouton_tentez_votre_chance.grid_forget()
            label_power_joueur.grid_forget()
            label_power_monstre.grid_forget()
            phrase_attaque.set("VOUS ETES MOOORT !!!")
            pt_perdus.set("'"+monstre.get_nom()+"' a eu raison de vous.")
            var_endurance.set(joueur.get_end())
            var_chance.set(joueur.get_cha())
            
            choix("combat")
            bouton_suite_combat.config(command=fenetre_combat.destroy)
            
        elif monstre.est_mort():
            bouton_des_monstre.grid_forget()
            bouton_des_joueur.grid_forget()
            bouton_tentez_votre_chance.grid_forget()
            label_power_joueur.grid_forget()
            label_power_monstre.grid_forget()
            phrase_attaque.set("FELICITATION !")
            pt_perdus.set("Vous avez vaincu '"+monstre.get_nom()+"'.")
            var_endurance.set(joueur.get_end())
            var_chance.set(joueur.get_cha())
            
            choix("combat")
            bouton_suite_combat.config(command=fenetre_combat.destroy)
        
        else :
            bouton_tentez_votre_chance.grid_remove()
            bouton_tentez_votre_chance.grid_forget()
            suite_combat.set("combat automatique")
            bouton_suite_combat.config(command=combat_auto)
            bouton_des_joueur.config(state=tk.NORMAL, relief='raised')
            bouton_des_monstre.config(state=tk.NORMAL, relief='raised')
            phrase_attaque.set("")
            pt_perdus.set("")
            
    fenetre_combat=tk.Tk()
    fenetre_combat.title("combat")
    fenetre_combat.geometry("600x350")
    
    nom_monstre=tk.StringVar(master=fenetre_combat)
    nom_monstre.set(monstre.get_nom())
    habilite_monstre=tk.IntVar(master=fenetre_combat)
    habilite_monstre.set(monstre.get_hab())
    endurance_monstre=tk.IntVar(master=fenetre_combat)
    endurance_monstre.set(monstre.get_end())
    habilite_joueur=tk.IntVar(master=fenetre_combat)
    habilite_joueur.set(joueur.get_hab())
    endurance_joueur=tk.IntVar(master=fenetre_combat)
    endurance_joueur.set(joueur.get_end())
    power_joueur=tk.StringVar(master=fenetre_combat)
    power_joueur.set("0")
    power_monstre=tk.StringVar(master=fenetre_combat)
    power_monstre.set("0")
    
    phrase_attaque=tk.StringVar(master=fenetre_combat)
    pt_perdus=tk.StringVar(master=fenetre_combat)
    suite_combat=tk.StringVar(master=fenetre_combat)
    
    
    
    label_vide_combat=tk.Label(fenetre_combat,text='                                    ')
    label_vide_combat.grid(row=0,column=0)
    label_titre_combat=tk.Label(fenetre_combat,text='COMBAT',fg='red', font=("Castellar"))
    label_titre_combat.grid(row=1,column=1,columnspan=5)
    label_vide2_combat=tk.Label(fenetre_combat,text='')
    label_vide2_combat.grid(row=2,column=0)
    label_nom_joueur=tk.Label(fenetre_combat,text='VOUS')
    label_nom_joueur.grid(row=3,column=1,columnspan=2)
    label_vs=tk.Label(fenetre_combat,text='                    VS                    ',font=('Algerian',12))
    label_vs.grid(row=3,column=3)
    label_nom_monstre=tk.Label(fenetre_combat,textvariable=nom_monstre)
    label_nom_monstre.grid(row=3,column=4,columnspan=2)
    label_hab_joueur_text=tk.Label(fenetre_combat,text='habilité :')
    label_hab_joueur_text.grid(row=4,column=1)
    label_hab_joueur_value=tk.Label(fenetre_combat,textvariable=habilite_joueur)
    label_hab_joueur_value.grid(row=4,column=2)
    label_hab_monstre_text=tk.Label(fenetre_combat,text='habilité :')
    label_hab_monstre_text.grid(row=4,column=4)
    label_hab_monstre_value=tk.Label(fenetre_combat,textvariable=habilite_monstre)
    label_hab_monstre_value.grid(row=4,column=5)
    label_end_joueur_text=tk.Label(fenetre_combat,text='endurance :')
    label_end_joueur_text.grid(row=5,column=1)
    label_end_joueur_value=tk.Label(fenetre_combat,textvariable=endurance_joueur)
    label_end_joueur_value.grid(row=5,column=2)
    label_end_monstre_text=tk.Label(fenetre_combat,text='endurance :')
    label_end_monstre_text.grid(row=5,column=4)
    label_end_monstre_value=tk.Label(fenetre_combat,textvariable=endurance_monstre)
    label_end_monstre_value.grid(row=5,column=5)
    
    label_vide3_combat=tk.Label(fenetre_combat,text='')
    label_vide3_combat.grid(row=6,column=0)
    bouton_des_joueur=tk.Button(fenetre_combat,text='Lancez les dés',command=fct_des_joueur)
    bouton_des_joueur.grid(row=7,column=1,columnspan=2)
    label_power_joueur=tk.Label(fenetre_combat,textvariable=power_joueur)
    label_power_joueur.grid(row=8,column=1,columnspan=2)
    bouton_des_monstre=tk.Button(fenetre_combat,text='Lancez les dés',command=fct_des_monstre)
    bouton_des_monstre.grid(row=7,column=4,columnspan=2)
    label_power_monstre=tk.Label(fenetre_combat,textvariable=power_monstre)
    label_power_monstre.grid(row=8,column=4,columnspan=2)
    
    label_phrase_attaque=tk.Label(fenetre_combat,textvariable=phrase_attaque,fg='red')
    label_phrase_attaque.grid(row=9,column=1,columnspan=5)
    label_pt_perdus=tk.Label(fenetre_combat,textvariable=pt_perdus,font=('consolas',8))
    label_pt_perdus.grid(row=10,column=1,columnspan=5)
    label_vide4_combat=tk.Label(fenetre_combat,text="")
    label_vide4_combat.grid(row=11,column=0)
    bouton_tentez_votre_chance=tk.Button(fenetre_combat,text='Tentez votre chance ('+str(joueur.get_cha())+")",command=fct_chance_combat,bg='green')
    bouton_tentez_votre_chance.grid(row=12,column=1,columnspan=5)
    bouton_suite_combat=tk.Button(fenetre_combat,textvariable=suite_combat,command=combat_auto)
    bouton_suite_combat.grid(row=13,column=1,columnspan=5,pady=10)
    suite_combat.set("combat automatique")
    
    bouton_tentez_votre_chance.grid_remove()
    bouton_tentez_votre_chance.grid_forget()
    
   
    
    
    
############################ FENETRE PRINCIPALE ##############################    


fenetre_smf=tk.Tk()
fenetre_smf.title("Le Sorcier de la montagne de feu")
fenetre_smf.geometry('660x325')



phrase1=tk.StringVar(master=fenetre_smf)
phrase2=tk.StringVar(master=fenetre_smf)
phrase3=tk.StringVar(master=fenetre_smf)
phrase4=tk.StringVar(master=fenetre_smf)
phrase_consolas=tk.StringVar(master=fenetre_smf)
bt1=tk.StringVar(master=fenetre_smf)
bt2=tk.StringVar(master=fenetre_smf)
bt3=tk.StringVar(master=fenetre_smf)
bt4=tk.StringVar(master=fenetre_smf)


var_habilite=tk.IntVar(master=fenetre_smf)
var_endurance=tk.IntVar(master=fenetre_smf)
var_chance=tk.IntVar(master=fenetre_smf)
var_or=tk.IntVar(master=fenetre_smf)
var_provisions=tk.IntVar(master=fenetre_smf)
var_potion=tk.IntVar(master=fenetre_smf)



label_vide1=tk.Label(fenetre_smf,text='')
label_vide1.grid(row=2,column=0)

label_vide2=tk.Label(fenetre_smf,text='                                                                                                                                                                     ')
label_vide2.grid(row=0,column=3,columnspan=6)


##### column 0

aide_1=tk.Button(fenetre_smf,text='?',command=aide_hab)
aide_1.grid(row=3,column=0)

aide_2=tk.Button(fenetre_smf,text='?',command=aide_end)
aide_2.grid(row=4,column=0)

aide_3=tk.Button(fenetre_smf,text='?',command=aide_chance)
aide_3.grid(row=5,column=0)

aide_4=tk.Button(fenetre_smf,text='?',command=aide_or)
aide_4.grid(row=6,column=0)

aide_5=tk.Button(fenetre_smf,text='?',command=aide_prov)
aide_5.grid(row=7,column=0)

aide_6=tk.Button(fenetre_smf,text='?',command=aide_potion)
aide_6.grid(row=8,column=0)

aide_7=tk.Button(fenetre_smf,text='?',command=aide_inv)
aide_7.grid(row=9,column=0)

aide_8=tk.Button(fenetre_smf,text='?',command=aide_journal)
aide_8.grid(row=10,column=0)


##### column 1

label_habilite=tk.Label(fenetre_smf,text='habilité',width=9,anchor='w')
label_habilite.grid(row=3,column=1)

label_endurance=tk.Label(fenetre_smf,text='endurance',width=9,anchor='w')
label_endurance.grid(row=4,column=1)

label_chance=tk.Label(fenetre_smf,text='chance',width=9,anchor='w')
label_chance.grid(row=5,column=1)

label_or=tk.Label(fenetre_smf,text='or',width=9,anchor='w')
label_or.grid(row=6,column=1)

label_provisions=tk.Label(fenetre_smf,text='provisions',width=9,anchor='w')
label_provisions.grid(row=7,column=1)

bouton_potion=tk.Button(fenetre_smf,text='potion',command=utiliser_potion,width=7,state=tk.DISABLED,relief='sunken')
bouton_potion.grid(row=8,column=1)

bouton_inventaire=tk.Button(fenetre_smf,text='inventaire',command=inventaire)
bouton_inventaire.grid(row=9,column=1)

bouton_journal=tk.Button(fenetre_smf,text='journal',width=7,command=affiche_journal)
bouton_journal.grid(row=10,column=1)


##### column 2

label_habilite_value=tk.Label(fenetre_smf,textvariable=var_habilite)
label_habilite_value.grid(row=3,column=2)

label_endurance_value=tk.Label(fenetre_smf,textvariable=var_endurance)
label_endurance_value.grid(row=4,column=2)

label_chance_value=tk.Label(fenetre_smf,textvariable=var_chance)
label_chance_value.grid(row=5,column=2)

label_or_value=tk.Label(fenetre_smf,textvariable=var_or)
label_or_value.grid(row=6,column=2)

label_provisions_value=tk.Label(fenetre_smf,textvariable=var_provisions)
label_provisions_value.grid(row=7,column=2)

label_potion_value=tk.Label(fenetre_smf,textvariable=var_potion)
label_potion_value.grid(row=8,column=2)


##############################################


label_titre=tk.Label(fenetre_smf,text='LE SORCIER DE LA MONTAGNE DE FEU', font=("Castellar"),fg='red')
label_titre.grid(row=1,column=3,columnspan=6)


##### texte

label_phrase1=tk.Label(fenetre_smf,textvariable=phrase1)
label_phrase1.grid(row=3,column=3,columnspan=6)

label_phrase2=tk.Label(fenetre_smf,textvariable=phrase2)
label_phrase2.grid(row=4,column=3,columnspan=6)

label_phrase3=tk.Label(fenetre_smf,textvariable=phrase3)
label_phrase3.grid(row=5,column=3,columnspan=6)

label_phrase4=tk.Label(fenetre_smf,textvariable=phrase4)
label_phrase4.grid(row=6,column=3,columnspan=6)

label_consolas=tk.Label(fenetre_smf,textvariable=phrase_consolas,font=('consolas',8))


##### boutons

bouton1=tk.Button(fenetre_smf,textvariable=bt1,command=lambda:[choix(1)], relief='raised',bg='red')
bouton1.grid(row=8,column=3,columnspan=2)

bouton2=tk.Button(fenetre_smf,textvariable=bt2,command=lambda:[choix(2)],relief='raised',bg='green')
bouton2.grid(row=8,column=5,columnspan=2)

bouton3=tk.Button(fenetre_smf,textvariable=bt3,command=lambda:[choix(3)],relief='raised',bg='blue')
bouton3.grid(row=8,column=7,columnspan=2)

bouton4=tk.Button(fenetre_smf,textvariable=bt4,command=lambda:[choix(4)],relief='raised',bg='white')


##### première page 

phrase1.set("Bienvenue dans 'Le Soricer de la montagne de feu'! ")
phrase2.set("La montagne de feu renferme bien des secrets. Personne n'en est revenu\nassez vivant pour réveler au monde ce qui se cache derrière ce flanc escarpé.")
phrase3.set("La légende raconte qu'elle est peuplée de monstres, mais qu'importe !\nVous vous êtes entrainé dûr pour arriver jusqu'ici.")
phrase4.set("Rien ne pourra vous détourner de votre objectif : prendre possession du trésor du sorcier.")
bt2.set("suite")
bouton1.grid_remove()
bouton1.grid_forget()
bouton2.config(bg='white')
bouton3.grid_remove()
bouton3.grid_forget()


fenetre_smf.mainloop()
